/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessLinux;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessMac;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessWin;
import com.teamdev.jxbrowser.chromium.internal.ipc.InternalChromiumProcess;

public final class ChromiumProcessFactory {
    public static ChromiumProcess create(String string) {
        if (Environment.isWindows()) {
            return new ExternalChromiumProcessWin(string);
        }
        if (Environment.isMac()) {
            if (Boolean.getBoolean("jxbrowser.ipc.external")) {
                return new ExternalChromiumProcessMac(string);
            }
            return new InternalChromiumProcess(string);
        }
        if (Environment.isLinux()) {
            return new ExternalChromiumProcessLinux(string);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

