/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcessLogger;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ExternalChromiumProcess
extends ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private Process b;
    private final File c;

    protected ExternalChromiumProcess(String var1, String var2) {
        super(var1);
        this.c = new File(var1, var2);
    }

    protected void preProcessRun(ProcessBuilder var1) {
        Map<String, String> var2 = BrowserPreferences.getChromiumVariables();
        if (!var2.isEmpty()) {
            Map<String, String> var4 = var1.environment();
            for (Map.Entry<String, String> var3 : var2.entrySet()) {
                var4.put(var3.getKey(), var3.getValue());
            }
        }
    }

    @Override
    protected int doStart(List<String> var1) {
        a.info("Starting Chromium process...");
        LinkedList<String> var2 = new LinkedList<String>();
        var2.add(this.c.getAbsolutePath());
        var2.addAll(var1);
        ProcessBuilder var8 = new ProcessBuilder(var2);
        var8.directory(new File(this.getWorkingDir()));
        Map<String, String> environment = var8.environment();
        a.info("reset CFProcessPath from value:" + environment.get("CFProcessPath"));
        environment.remove("CFProcessPath");
        var8.redirectErrorStream(true);
        this.preProcessRun(var8);
        try {
            StringBuilder var3 = new StringBuilder();
            for (String var4 : var2) {
                var3.append(var4);
                var3.append(' ');
            }
            a.info("Command line: " + var3);
            this.b = var8.start();
            new ChromiumProcessLogger().startLogging(this.b);
            int var10 = this.b.waitFor();
            this.b = null;
            return var10;
        }
        catch (InterruptedException var5) {
            throw new RuntimeException(var5);
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
        catch (Exception var7) {
            throw new RuntimeException(var7);
        }
    }

    @Override
    public boolean isStarted() {
        return this.b != null;
    }
}

