/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.IPCLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.m;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.NonBlockingMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class MemoryChannelWriter
implements Runnable {
    private static final IPCLogger a = (IPCLogger)LoggerProvider.getIPCLogger();
    private final SocketInfo b;
    private final ChannelStream c;
    private final AtomicBoolean d;
    private final BlockingQueue<Message> e;
    private final SharedMemory f;

    public MemoryChannelWriter(ChannelStream channelStream, SharedMemory sharedMemory, SocketInfo socketInfo) {
        this.c = channelStream;
        this.f = sharedMemory;
        this.b = socketInfo;
        this.d = new AtomicBoolean();
        this.e = new LinkedBlockingQueue<Message>();
        this.c.addChannelStreamListener(new m(this));
    }

    public void blockWriteMessages() {
        this.d.set(true);
    }

    public void write(Message message) {
        if (this.c.isClosed()) {
            throw new IllegalStateException("Failed to send message. Channel is already closed. " + message);
        }
        if (this.d.get() && !message.getType().isCallback() && !(message instanceof NonBlockingMessage)) {
            return;
        }
        this.e.add(message);
    }

    @Override
    public void run() {
        if (this.c.isClosed()) {
            return;
        }
        while (!this.c.isClosed()) {
            Message message = null;
            try {
                message = this.e.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (message == null || message instanceof a) continue;
            if (a.isLoggable(Level.INFO) && a.isMessageTypeEnabled(message.getType())) {
                a.info("WRITE: " + message + ", " + this.b);
            }
            try {
                byte[] byArray = new byte[message.getSize()];
                message.serialize(byArray);
                this.f.write(byArray);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Unexpected error in channel writer.", exception);
                break;
            }
        }
        this.e.clear();
        this.c.close();
    }

    static /* synthetic */ BlockingQueue a(MemoryChannelWriter memoryChannelWriter) {
        return memoryChannelWriter.e;
    }

    static final class a
    implements Message {
        private a() {
        }

        @Override
        public final int getUID() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final MessageType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void serialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void deserialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

