/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.SharedMemoryCallback;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class SharedMemory {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private static final AtomicInteger b = new AtomicInteger(0);
    private final long c;

    public SharedMemory(String string, SharedMemoryCallback sharedMemoryCallback) {
        this.c = SharedMemoryLibrary.getInstance().createConnection(string, 65535, sharedMemoryCallback);
        a.info("IPC connection has been established. Connection ID: " + this.c);
        if (this.c == 0L) {
            throw new IllegalStateException("Failed to allocate shared memory.");
        }
        b.incrementAndGet();
    }

    public byte[] getConnectionData() {
        return SharedMemoryLibrary.getInstance().getIpcInitData(this.c);
    }

    public void write(byte[] byArray) {
        SharedMemoryLibrary.getInstance().sendData(this.c, byArray);
    }

    public void close() {
        SharedMemoryLibrary.getInstance().closeConnection(this.c);
        a.info("IPC connection has been closed. Connection ID: " + this.c);
        a.info("Pending IPC connections: " + b.decrementAndGet());
    }
}

