/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.EventQueue;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelException;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.MemoryChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.MemoryChannelWriter;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelStreamListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.p;
import com.teamdev.jxbrowser.chromium.internal.ipc.s;
import com.teamdev.jxbrowser.chromium.internal.ipc.t;
import com.teamdev.jxbrowser.chromium.internal.ipc.u;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javafx.application.Platform;

public class SocketChannel
implements Channel {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final ChannelStream b;
    private final SocketInfo c;
    private final MemoryChannelWriter d;
    private final AtomicInteger e;
    private final List<ChannelListener> f;
    private final EventQueue g;
    private final EventQueue h;

    public SocketChannel(ChannelStream channelStream, SocketInfo socketInfo, MemoryChannelReader memoryChannelReader, MemoryChannelWriter memoryChannelWriter) {
        this.b = channelStream;
        this.c = socketInfo;
        this.d = memoryChannelWriter;
        this.g = EventQueue.createCachedEventQueue("IPC Sync Events Thread");
        this.h = EventQueue.createFixedEventQueue("IPC Async Events Thread");
        this.e = new AtomicInteger();
        this.f = new CopyOnWriteArrayList<ChannelListener>();
        memoryChannelReader.addChannelListener(new p(this));
        channelStream.addChannelStreamListener(new s(this));
    }

    @Override
    public long getChannelId() {
        return this.c.getChannelId();
    }

    @Override
    public long getBrowserId() {
        return this.c.getBrowserId();
    }

    @Override
    public boolean isClosed() {
        return this.b.isClosed();
    }

    @Override
    public ChannelType getType() {
        return this.c.getChannelType();
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        if (!this.f.contains(channelListener)) {
            this.f.add(channelListener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        this.f.remove(channelListener);
    }

    @Override
    public List<ChannelListener> getChannelListeners() {
        return new ArrayList<ChannelListener>(this.f);
    }

    @Override
    public void blockWriteMessages() {
        this.d.blockWriteMessages();
    }

    @Override
    public void waitForPendingPostRequests() {
        while (this.e.get() != 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void send(Message message) {
        this.d.write(message);
    }

    private void a(ChannelStreamListener channelStreamListener) {
        this.b.removeChannelStreamListener(channelStreamListener);
    }

    @Override
    public <T extends Message> T post(T t2) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicReference = new AtomicReference();
        t t3 = new t(this, t2, atomicReference, countDownLatch);
        u u2 = new u(this, countDownLatch);
        this.addChannelListener(t3);
        u u3 = u2;
        SocketChannel socketChannel = this;
        socketChannel.b.addChannelStreamListener(u3);
        this.e.incrementAndGet();
        try {
            this.send(t2);
            if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
                while (countDownLatch.getCount() != 0L) {
                    SharedMemoryLibrary.getInstance().runPendingTasks();
                }
            }
            LatchUtil.await(countDownLatch, new ChannelException("Failed to send message.", new TimeoutException()));
        }
        finally {
            this.removeChannelListener(t3);
            this.a(u2);
            this.e.decrementAndGet();
        }
        if (atomicReference.get() == null) {
            throw new IllegalStateException("Channel stream was closed before response has been received.");
        }
        return (T)((Message)atomicReference.get());
    }

    public String toString() {
        return "SocketChannel{cid=" + this.c.getChannelId() + ", bid=" + this.c.getBrowserId() + ", type=" + (Object)((Object)this.c.getChannelType()) + '}';
    }

    static /* synthetic */ EventQueue a(SocketChannel socketChannel) {
        return socketChannel.g;
    }

    static /* synthetic */ EventQueue b(SocketChannel socketChannel) {
        return socketChannel.h;
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static abstract class a<T extends Message>
    implements ChannelListener {
        private final Message a;

        protected a(Message message) {
            this.a = message;
        }

        @Override
        public final void onMessageReceived(Message message) {
            boolean bl;
            boolean bl2 = this.a.getUID() == message.getUID();
            boolean bl3 = bl = this.a.getType() == message.getType();
            if (bl2 && bl) {
                this.a(message);
            }
        }

        public abstract void a(T var1);
    }
}

