/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.DataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageField;

public class DragTargetMessage
extends DataMessage {
    @MessageField
    private int flag;
    @MessageField
    private int clientX;
    @MessageField
    private int clientY;
    @MessageField
    private int screenX;
    @MessageField
    private int screenY;
    @MessageField
    private int operations;
    @MessageField
    private int keyModifiers;
    @MessageField
    private String url;
    @MessageField
    private String urlTitle;
    @MessageField
    private String text;
    @MessageField
    private String html;
    @MessageField
    private String customData;
    @MessageField
    private String htmlBaseURL;

    public DragTargetMessage(int n2) {
        super(n2);
    }

    public DragTargetMessage(int n2, Flag flag, int n3, int n4, int n5, int n6, WebDragOperation webDragOperation, int n7, String string, String string2, String string3, String string4, String string5, String string6) {
        super(n2);
        this.flag = flag.a;
        this.clientX = n3;
        this.clientY = n4;
        this.screenX = n5;
        this.screenY = n6;
        this.operations = webDragOperation.a;
        this.keyModifiers = n7;
        this.url = string;
        this.urlTitle = string2;
        this.text = string3;
        this.html = string4;
        this.customData = string5;
        this.htmlBaseURL = string6;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getClientX() {
        return this.clientX;
    }

    public int getClientY() {
        return this.clientY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public int getOperations() {
        return this.operations;
    }

    public int getKeyModifiers() {
        return this.keyModifiers;
    }

    public String getURL() {
        return this.url;
    }

    public String getURLTitle() {
        return this.urlTitle;
    }

    public String getText() {
        return this.text;
    }

    public String getHTML() {
        return this.html;
    }

    public String getCustomData() {
        return this.customData;
    }

    public String getHTMLBaseURL() {
        return this.htmlBaseURL;
    }

    public String toString() {
        return "DragTargetMessage{type=" + (Object)((Object)this.getType()) + ", uid = " + this.getUID() + ", flag=" + this.flag + ", clientX=" + this.clientX + ", clientY=" + this.clientY + ", screenX=" + this.screenX + ", screenY=" + this.screenY + ", operations=" + this.operations + ", keyModifiers=" + this.keyModifiers + ", url='" + this.url + '\'' + ", urlTitle='" + this.urlTitle + '\'' + ", text='" + this.text + '\'' + ", html='" + this.html + '\'' + ", customData='" + this.customData + '\'' + ", htmlBaseURL='" + this.htmlBaseURL + '\'' + '}';
    }

    public static enum WebDragOperation {
        WebDragOperationNone(0),
        WebDragOperationCopy(1),
        WebDragOperationLink(2),
        WebDragOperationGeneric(4),
        WebDragOperationPrivate(8),
        WebDragOperationMove(16),
        WebDragOperationDelete(32),
        WebDragOperationEvery(-1);

        private final int a;

        private WebDragOperation(int n3) {
            this.a = n3;
        }

        public static WebDragOperation valueOf(int n2) {
            for (WebDragOperation webDragOperation : WebDragOperation.values()) {
                if (webDragOperation.a != n2) continue;
                return webDragOperation;
            }
            throw new IllegalArgumentException("Unsupported value: " + n2);
        }

        public static WebDragOperation fromSwing(int n2) {
            WebDragOperation webDragOperation = WebDragOperationNone;
            if (n2 == 1) {
                webDragOperation = WebDragOperationCopy;
            } else if (n2 == 2) {
                webDragOperation = WebDragOperationMove;
            } else if (n2 == 0x40000000) {
                webDragOperation = WebDragOperationLink;
            } else if (n2 == 0) {
                webDragOperation = WebDragOperationNone;
            } else if (n2 == 3) {
                webDragOperation = WebDragOperationCopy;
            }
            return webDragOperation;
        }
    }

    public static enum Flag {
        DragTargetDragEnter(0),
        DragTargetDragLeave(1),
        DragTargetDragOver(2),
        DragTargetDrop(3);

        private final int a;

        private Flag(int n3) {
            this.a = n3;
        }

        public static Flag valueOf(int n2) {
            for (Flag flag : Flag.values()) {
                if (flag.a != n2) continue;
                return flag;
            }
            throw new IllegalArgumentException("Unsupported value: " + n2);
        }
    }
}

