/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageFactory;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import java.nio.ByteBuffer;

public class MessageSerializer {
    public static final int MSG_DATA_OFFSET = 12;
    public static final int MSG_TYPE_OFFSET = 0;
    public static final int MSG_UID_OFFSET = 4;
    public static final int MSG_DATA_SIZE_OFFSET = 8;

    public int getMessageSize(byte[] byArray) {
        if (byArray.length < 12) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = byteBuffer.getInt(8);
        if (byArray.length < (n2 += 12)) {
            return -1;
        }
        return n2;
    }

    public Message deserialize(byte[] object, int n2) {
        if (((byte[])object).length < n2) {
            throw new IllegalStateException("Bytes length must be > messageSize.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object, 0, n2);
        object = byteBuffer;
        n2 = byteBuffer.getInt(0);
        int n3 = ((ByteBuffer)object).getInt(4);
        MessageType messageType = MessageType.from(n2);
        Message message = MessageFactory.create(messageType, n3);
        try {
            message.deserialize(((ByteBuffer)object).array());
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to deserialize message: " + (Object)((Object)messageType), exception);
        }
        return message;
    }

    public byte[] serialize(Message message) {
        byte[] byArray = new byte[message.getSize()];
        message.serialize(byArray);
        return byArray;
    }
}

