/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx;

import com.teamdev.jxbrowser.chromium.Certificate;
import com.teamdev.jxbrowser.chromium.CertificatesDialogParams;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.ColorChooserParams;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DialogParams;
import com.teamdev.jxbrowser.chromium.FileChooserParams;
import com.teamdev.jxbrowser.chromium.PromptDialogParams;
import com.teamdev.jxbrowser.chromium.ReloadPostDataParams;
import com.teamdev.jxbrowser.chromium.UnloadDialogParams;
import com.teamdev.jxbrowser.chromium.javafx.f;
import com.teamdev.jxbrowser.chromium.javafx.g;
import com.teamdev.jxbrowser.chromium.javafx.internal.dialogs.ConfirmDialog;
import com.teamdev.jxbrowser.chromium.javafx.internal.dialogs.MessageDialog;
import com.teamdev.jxbrowser.chromium.javafx.internal.dialogs.PromptDialog;
import com.teamdev.jxbrowser.chromium.javafx.internal.dialogs.SelectDialog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Node;

public class DefaultDialogHandler
implements DialogHandler {
    private final Node a;

    public DefaultDialogHandler(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The node parameter cannot be null.");
        }
        this.a = node;
    }

    @Override
    public void onAlert(DialogParams object) {
        String string = ((DialogParams)object).getURL();
        string = "The page at " + string + " says:";
        object = ((DialogParams)object).getMessage();
        MessageDialog.show(this.a, string, (String)object);
    }

    @Override
    public CloseStatus onConfirmation(DialogParams object) {
        String string = ((DialogParams)object).getURL();
        string = "The page at " + string + " says:";
        object = ((DialogParams)object).getMessage();
        return ConfirmDialog.show(this.a, string, (String)object);
    }

    @Override
    public CloseStatus onPrompt(PromptDialogParams promptDialogParams) {
        AtomicReference<String> atomicReference;
        Object object = promptDialogParams.getURL();
        object = "The page at " + object + " says:";
        String string = promptDialogParams.getMessage();
        if ((object = PromptDialog.show(this.a, object, string, atomicReference = new AtomicReference<String>())) == CloseStatus.OK) {
            promptDialogParams.setPromptText(atomicReference.get());
        }
        return object;
    }

    @Override
    public CloseStatus onFileChooser(FileChooserParams fileChooserParams) {
        AtomicReference<CloseStatus> atomicReference = new AtomicReference<CloseStatus>(CloseStatus.CANCEL);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater((Runnable)new f(this, fileChooserParams, atomicReference, countDownLatch));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return atomicReference.get();
    }

    @Override
    public CloseStatus onBeforeUnload(UnloadDialogParams unloadDialogParams) {
        String string = "Confirm Navigation";
        String string2 = unloadDialogParams.getMessage();
        String string3 = "Leave this Page";
        String string4 = "Stay on this Page";
        if (unloadDialogParams.isReload()) {
            string = "Confirm Reload";
            string3 = "Reload this Page";
            string4 = "Don't Reload";
        }
        return ConfirmDialog.show(this.a, string, string2, string3, string4);
    }

    @Override
    public CloseStatus onSelectCertificate(CertificatesDialogParams certificatesDialogParams) {
        AtomicReference<Object> atomicReference;
        Object object = "Select a certificate to authenticate yourself to " + certificatesDialogParams.getHostPortPair().getHostPort();
        Certificate[] certificateArray = certificatesDialogParams.getCertificates();
        if (!certificateArray.isEmpty() && (object = SelectDialog.show(this.a, object, "Select a certificate", certificateArray = certificateArray.toArray(new Certificate[certificateArray.size()]), atomicReference = new AtomicReference<Object>())) == CloseStatus.OK) {
            certificatesDialogParams.setSelectedCertificate((Certificate)atomicReference.get());
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    @Override
    public CloseStatus onReloadPostData(ReloadPostDataParams object) {
        object = "Confirm Form Resubmission";
        String string = "The page that you're looking for used information that you entered.\nReturning to that page might cause any action you took to be repeated.\nDo you want to continue?";
        String string2 = "Continue";
        String string3 = "Cancel";
        return ConfirmDialog.show(this.a, (String)object, string, string2, string3);
    }

    @Override
    public CloseStatus onColorChooser(ColorChooserParams colorChooserParams) {
        AtomicReference<CloseStatus> atomicReference = new AtomicReference<CloseStatus>(CloseStatus.CANCEL);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater((Runnable)new g(this, countDownLatch, colorChooserParams, atomicReference));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return atomicReference.get();
    }

    static /* synthetic */ Node a(DefaultDialogHandler defaultDialogHandler) {
        return defaultDialogHandler.a;
    }
}

