/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.javafx.internal.HeavyWeightWidget;
import com.teamdev.jxbrowser.chromium.javafx.internal.LightWeightWidget;
import com.teamdev.jxbrowser.chromium.javafx.internal.Widget;

public final class WidgetFactory {
    public static Widget create(Browser browser) {
        IPC iPC = (IPC)ReflectionUtil.invokeMethod(browser, "getIPC");
        Channel channel = (Channel)ReflectionUtil.invokeMethod(browser, "getChannel");
        if (browser.getType() == BrowserType.LIGHTWEIGHT) {
            return new LightWeightWidget(browser);
        }
        if (browser.getType() == BrowserType.HEAVYWEIGHT) {
            return new HeavyWeightWidget(iPC, channel);
        }
        throw new IllegalArgumentException("Unsupported BrowserType: " + (Object)((Object)browser.getType()));
    }
}

