/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public enum CursorType {
    TypePointer,
    TypeCross,
    TypeHand,
    TypeIBeam,
    TypeWait,
    TypeHelp,
    TypeEastResize,
    TypeNorthResize,
    TypeNorthEastResize,
    TypeNorthWestResize,
    TypeSouthResize,
    TypeSouthEastResize,
    TypeSouthWestResize,
    TypeWestResize,
    TypeNorthSouthResize,
    TypeEastWestResize,
    TypeNorthEastSouthWestResize,
    TypeNorthWestSouthEastResize,
    TypeColumnResize,
    TypeRowResize,
    TypeMiddlePanning,
    TypeEastPanning,
    TypeNorthPanning,
    TypeNorthEastPanning,
    TypeNorthWestPanning,
    TypeSouthPanning,
    TypeSouthEastPanning,
    TypeSouthWestPanning,
    TypeWestPanning,
    TypeMove,
    TypeVerticalText,
    TypeCell,
    TypeContextMenu,
    TypeAlias,
    TypeProgress,
    TypeNoDrop,
    TypeCopy,
    TypeNone,
    TypeNotAllowed,
    TypeZoomIn,
    TypeZoomOut,
    TypeGrab,
    TypeGrabbing,
    TypeCustom;

    private static final Properties a;
    private static final Logger b;

    public static Cursor toJavaCursor(int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        CursorType[] cursorTypeArray = CursorType.values();
        if (n2 < cursorTypeArray.length) {
            Object object = cursorTypeArray[n2];
            if (object == TypeCustom) {
                BufferedImage bufferedImage;
                BufferedImage bufferedImage2;
                int n7;
                int n8;
                if (n3 == 0 || n4 == 0) {
                    return null;
                }
                object = Toolkit.getDefaultToolkit().getBestCursorSize(n3, n4);
                int n9 = ((Dimension)object).width;
                int n10 = ((Dimension)object).height;
                if (n9 == 0 && n10 == 0) {
                    return Cursor.getDefaultCursor();
                }
                int n11 = n3;
                int n12 = n4;
                int n13 = n9;
                n9 = n10;
                n4 = n13;
                n3 = n12;
                int n14 = n11;
                Object object2 = byArray;
                int[] nArray = new int[byArray.length / 4];
                int n15 = 0;
                for (int i2 = 0; i2 < ((byte[])object2).length; i2 += 4) {
                    n8 = object2[i2 + 3] & 0xFF;
                    n7 = object2[i2 + 2] & 0xFF;
                    int n16 = object2[i2 + 1] & 0xFF;
                    int n17 = object2[i2] & 0xFF;
                    nArray[n15++] = n8 << 24 | n7 << 16 | n16 << 8 | n17;
                }
                if (Environment.isWindows()) {
                    n8 = n14 >= n4 ? n14 : n4;
                    n7 = n3 >= n9 ? n3 : n9;
                    bufferedImage2 = new BufferedImage(n8, n7, 2);
                    if (n14 < n4 || n3 < n9) {
                        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                        graphics2D.setColor(new Color(0, 0, 0, 0));
                        graphics2D.setComposite(AlphaComposite.getInstance(4));
                        graphics2D.fillRect(0, 0, n4, n9);
                    }
                } else {
                    bufferedImage2 = new BufferedImage(n14, n3, 2);
                }
                for (n8 = 0; n8 < n3; ++n8) {
                    for (n7 = 0; n7 < n14; ++n7) {
                        bufferedImage2.setRGB(n7, n8, nArray[n7 + n8 * n14]);
                    }
                }
                if (n14 != n4 || n3 != n9) {
                    bufferedImage = new BufferedImage(n4, n9, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.drawImage(bufferedImage2, 0, 0, n4, n9, null);
                } else {
                    bufferedImage = bufferedImage2;
                }
                object2 = bufferedImage;
                return Toolkit.getDefaultToolkit().createCustomCursor((Image)object2, new Point(n5, n6), "customCursor");
            }
            return CursorType.a(object.name());
        }
        return Cursor.getDefaultCursor();
    }

    private static Cursor a(String string) {
        try {
            Object object = string + ".file";
            if (Environment.isMac()) {
                object = (String)object + ".mac";
            }
            if ((object = a.getProperty((String)object)) != null) {
                object = CursorType.class.getResource((String)object);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                object = toolkit.getImage((URL)object);
                Point point = new Point(0, 0);
                Object object2 = a.getProperty(string + ".hotspot");
                if (object2 != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ","))).countTokens() == 2) {
                    try {
                        point.x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        point.y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        b.warning("Failed to parse hotspot property for cursor: " + string);
                    }
                }
                object2 = toolkit.createCustomCursor((Image)object, point, string);
                return object2;
            }
            object = a.getProperty(string + ".swing");
            if (object != null) {
                int n2 = Cursor.class.getDeclaredField((String)object).getInt(null);
                return new Cursor(n2);
            }
        }
        catch (Exception exception) {
            b.warning("Unable to load cursor from resources: " + string);
        }
        return Cursor.getDefaultCursor();
    }

    static {
        a = new Properties();
        b = LoggerProvider.getBrowserLogger();
        URL uRL = CursorType.class.getResource("/com/teamdev/jxbrowser/chromium/internal/cursors.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                a.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                b.warning("Unable to load cursors properties from:" + uRL);
            }
        }
    }
}

