/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.InputEventsHandler;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.events.GestureEvent;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropData;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.MouseDragEventConverter;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.TaskExecutor;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragEndedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragTargetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCursorChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetParentForWindowlessPluginMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPaintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowPopupWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStartDraggingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTakeFocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTooltipChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ScreenChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UnfocusMessage;
import com.teamdev.jxbrowser.chromium.swing.internal.CursorType;
import com.teamdev.jxbrowser.chromium.swing.internal.DragAndDropSupport;
import com.teamdev.jxbrowser.chromium.swing.internal.LightWeightPopup;
import com.teamdev.jxbrowser.chromium.swing.internal.MacShortcutsCommandFactory;
import com.teamdev.jxbrowser.chromium.swing.internal.MemoryImage;
import com.teamdev.jxbrowser.chromium.swing.internal.Native;
import com.teamdev.jxbrowser.chromium.swing.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.chromium.swing.internal.TransferableWrapper;
import com.teamdev.jxbrowser.chromium.swing.internal.Widget;
import com.teamdev.jxbrowser.chromium.swing.internal.events.LightWeightWidgetListener;
import com.teamdev.jxbrowser.chromium.swing.internal.r;
import com.teamdev.jxbrowser.chromium.swing.internal.s;
import com.teamdev.jxbrowser.chromium.swing.internal.t;
import com.teamdev.jxbrowser.chromium.swing.internal.u;
import com.teamdev.jxbrowser.chromium.swing.internal.v;
import com.teamdev.jxbrowser.chromium.swing.internal.w;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class LightWeightWidget
extends Widget {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final NativeKeyCodes b;
    private final MemoryImage c = new MemoryImage();
    private final KeyListener d;
    private final FocusListener e;
    private final f f = new f(this, 0);
    private final ChannelListener g;
    private final TaskExecutor h;
    private final ComponentListener i;
    private final ComponentListener j;
    private final IPCChannelListener k;
    private final DragAndDropSupport l;
    private final MouseDragEventConverter m;
    private final List<LightWeightWidgetListener> n;
    private int o;
    private boolean p;
    private InputEventsHandler<KeyEvent> q;
    private InputEventsHandler<MouseEvent> r;
    private MacShortcutSupport<KeyEvent> s;

    LightWeightWidget(Browser browser) {
        this((IPC)ReflectionUtil.invokeMethod(browser, "getIPC"), (Channel)ReflectionUtil.invokeMethod(browser, "getChannel"));
        if (Environment.isMac()) {
            this.s = new b(browser);
        }
    }

    public LightWeightWidget(IPC object, Channel channel) {
        super((IPC)object, channel);
        this.d = new e(this, 0);
        this.i = new g(this, 0);
        this.e = new d(this, 0);
        this.j = new i(this, 0);
        this.g = new c(this, 0);
        object = new h(this, 0);
        this.l = new DragAndDropSupport((DropTargetListener)object, (DragSourceListener)object);
        this.m = new MouseDragEventConverter();
        this.k = new a(this, 0);
        this.n = new ArrayList<LightWeightWidgetListener>();
        this.b = new NativeKeyCodes();
        this.h = new TaskExecutor("Swing WidgetView Resize Task Executor");
        this.h.start();
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setTransferHandler(new r(this));
        object = this;
        ((Widget)object).getIPC().addIPCChannelListener(((LightWeightWidget)object).k);
        object = this;
        ((Widget)object).getChannel().addChannelListener(((LightWeightWidget)object).g);
    }

    final void a(boolean bl) {
        this.p = bl;
    }

    public void addLightWeightWidgetListener(LightWeightWidgetListener lightWeightWidgetListener) {
        if (!this.n.contains(lightWeightWidgetListener)) {
            this.n.add(lightWeightWidgetListener);
        }
    }

    public void removeLightWeightWidgetListener(LightWeightWidgetListener lightWeightWidgetListener) {
        this.n.remove(lightWeightWidgetListener);
    }

    public List<LightWeightWidgetListener> getLightWeightWidgetListeners() {
        return new ArrayList<LightWeightWidgetListener>(this.n);
    }

    public Image getImage() {
        return this.c.getImage();
    }

    @Override
    public void setDragAndDropEnabled(boolean bl) {
        this.l.setDragAndDropEnabled(bl);
    }

    @Override
    public boolean isDragAndDropEnabled() {
        return this.l.isDragAndDropEnabled();
    }

    public double getDeviceScaleFactor() {
        return this.c.getDeviceScaleFactor();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            super.processMouseMotionEvent(mouseEvent);
            if (this.a(mouseEvent)) {
                this.forwardMouseEvent(mouseEvent);
            }
            return;
        }
        if (mouseEvent.getID() == 506 && this.l.isDragStarted()) {
            super.processMouseMotionEvent(mouseEvent);
            if (this.l.isDragGestureRecognized()) {
                this.l.setDragStarted(false);
                this.l.setDragGestureRecognized(false);
                return;
            }
        } else if (this.a(mouseEvent)) {
            this.forwardMouseEvent(mouseEvent);
        }
    }

    private void b() {
        this.c.setVisible(false);
        this.removeFocusListener(this.e);
        this.removeComponentListener(this.i);
        this.removeKeyListener(this.d);
        this.removeMouseListener(this.f);
        this.removeMouseMotionListener(this.f);
        this.removeMouseWheelListener(this.f);
        this.l.unregisterDragGestureHandler();
        this.repaint();
    }

    private void c() {
        if (!this.c.isVisible()) {
            this.setBounds(this.getBounds());
            this.addFocusListener(this.e);
            this.addMouseListener(this.f);
            this.addMouseMotionListener(this.f);
            this.addMouseWheelListener(this.f);
            this.addKeyListener(this.d);
            this.addComponentListener(this.i);
            this.c.setVisible(true);
            this.l.registerDragGestureHandler(this);
            this.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.c();
        if (Environment.isMac()) {
            LightWeightWidget lightWeightWidget = this;
            Window window = SwingUtilities.getWindowAncestor(lightWeightWidget);
            if (window != null) {
                window.addComponentListener(lightWeightWidget.j);
            }
            this.d();
        }
    }

    @Override
    public void removeNotify() {
        LightWeightWidget lightWeightWidget;
        Window window;
        if (Environment.isMac() && (window = SwingUtilities.getWindowAncestor(lightWeightWidget = this)) != null) {
            window.removeComponentListener(lightWeightWidget.j);
        }
        this.setBounds(new Rectangle());
        this.b();
        super.removeNotify();
    }

    @Override
    public void dispose() {
        LightWeightWidget lightWeightWidget = this;
        lightWeightWidget.getIPC().removeIPCChannelListener(lightWeightWidget.k);
        lightWeightWidget = this;
        lightWeightWidget.getChannel().removeChannelListener(lightWeightWidget.g);
        this.h.stop();
    }

    @Override
    public void setKeyEventsHandler(InputEventsHandler<KeyEvent> inputEventsHandler) {
        this.q = inputEventsHandler;
    }

    @Override
    public void setMouseEventsHandler(InputEventsHandler<MouseEvent> inputEventsHandler) {
        this.r = inputEventsHandler;
    }

    @Override
    public void setGestureEventsHandler(InputEventsHandler<GestureEvent> inputEventsHandler) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.c.isVisible() && this.c.isInitialized()) {
            int n2 = this.c.getWidth();
            int n3 = this.c.getHeight();
            graphics = (Graphics2D)graphics;
            if (Environment.isMac()) {
                double d2 = 1.0 / this.c.getDeviceScaleFactor();
                ((Graphics2D)graphics).scale(d2, d2);
            }
            graphics.drawImage(this.c.getImage(), 0, 0, n2, n3, null);
        }
    }

    public void forwardMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.a(mouseWheelEvent, Environment.isMac() ? 10 : 25);
    }

    private void a(MouseWheelEvent mouseWheelEvent, int n2) {
        Serializable serializable = mouseWheelEvent.getComponent();
        serializable = serializable.getLocationOnScreen();
        int n3 = ((Point)serializable).x;
        int n4 = ((Point)serializable).y;
        int n5 = mouseWheelEvent.getX();
        int n6 = mouseWheelEvent.getY();
        int n7 = mouseWheelEvent.getX();
        int n8 = mouseWheelEvent.getY();
        int n9 = -mouseWheelEvent.getUnitsToScroll();
        int n10 = -mouseWheelEvent.getWheelRotation();
        int n11 = mouseWheelEvent.getScrollType();
        long l2 = mouseWheelEvent.getWhen();
        int n12 = mouseWheelEvent.getModifiersEx();
        boolean bl = mouseWheelEvent.isShiftDown();
        if (Environment.isWindows()) {
            double d2 = this.c.getDeviceScaleFactor();
            n5 = (int)((double)n5 / d2);
            n6 = (int)((double)n6 / d2);
            n7 = (int)((double)n7 / d2);
            n8 = (int)((double)n8 / d2);
        }
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new ForwardMouseWheelMessage(MessageUIDGenerator.generate(), n5, n6, n7, n8, n3, n4, n11, n10, n9, l2, n12, bl, n2));
        }
    }

    public void forwardTouchMoveEvent(MouseEvent iterator) {
        iterator = this.m.getMouseWheelEvents((MouseEvent)((Object)iterator));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            MouseWheelEvent mouseWheelEvent = iterator.next();
            this.a(mouseWheelEvent, 1);
        }
    }

    private boolean a(MouseEvent mouseEvent) {
        if (this.r != null) {
            try {
                return !this.r.handle(mouseEvent);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The MouseEventsHandler.handle() method has thrown exception: ", exception);
            }
        }
        return true;
    }

    public void forwardMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getID() == 506 && Environment.isWindows() && !(bl = SharedMemoryLibrary.getInstance().isCursorVisible())) {
            this.forwardTouchMoveEvent(mouseEvent);
            return;
        }
        this.m.reset();
        Serializable serializable = mouseEvent.getComponent();
        serializable = serializable.isShowing() ? serializable.getLocationOnScreen() : new Point();
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = ((Point)serializable).x + n3;
        int n6 = ((Point)serializable).y + n4;
        MouseEvent mouseEvent2 = mouseEvent;
        int n7 = SwingUtilities.isLeftMouseButton(mouseEvent2) ? 1 : (SwingUtilities.isMiddleMouseButton(mouseEvent2) ? 2 : (SwingUtilities.isRightMouseButton(mouseEvent2) ? 3 : 0));
        int n8 = mouseEvent.getClickCount();
        long l2 = mouseEvent.getWhen();
        int n9 = mouseEvent.getModifiersEx();
        if (Environment.isWindows()) {
            double d2 = this.c.getDeviceScaleFactor();
            n3 = (int)((double)n3 / d2);
            n4 = (int)((double)n4 / d2);
            n5 = (int)((double)n5 / d2);
            n6 = (int)((double)n6 / d2);
        }
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new ForwardMouseMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, n6, n3, n4, n7, n8, l2, n9));
        }
    }

    public void forwardKeyPressedEvent(KeyEvent keyEvent) {
        this.o = Environment.isWindows() ? LightWeightWidget.a(keyEvent) : keyEvent.getKeyCode();
        this.a(keyEvent, 401, keyEvent.getWhen());
    }

    public void forwardKeyTypedEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2;
        if (Environment.isWindows()) {
            int n2 = this.o != 0 ? this.o : LightWeightWidget.a(keyEvent);
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n2, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            long l2 = n2;
            KeyEvent keyEvent3 = keyEvent2;
            try {
                Field field = keyEvent3.getClass().getDeclaredField("rawCode");
                field.setAccessible(true);
                field.setLong(keyEvent3, l2);
            }
            catch (IllegalAccessException illegalAccessException) {
                a.log(Level.SEVERE, "Failed to set native key code.", illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                a.log(Level.SEVERE, "Failed to set native key code.", noSuchFieldException);
            }
        } else {
            int n3 = this.o != 0 ? this.o : keyEvent.getKeyCode();
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n3, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        this.a(keyEvent2, 400, keyEvent.getWhen());
    }

    public void forwardKeyReleasedEvent(KeyEvent keyEvent) {
        this.o = 0;
        this.a(keyEvent, 402, keyEvent.getWhen());
    }

    private void a(KeyEvent object, int n2, long l2) {
        int n3;
        int n4;
        char c2 = ((KeyEvent)object).getKeyChar();
        int n32 = ((InputEvent)object).getModifiersEx();
        int n42 = ((KeyEvent)object).getKeyCode();
        int n5 = ((KeyEvent)object).getKeyLocation();
        int n6 = this.b.toNativeKeyCode(n42, n5);
        if (Environment.isWindows() && (n4 = LightWeightWidget.a((KeyEvent)object)) != 0) {
            n3 = n4;
        }
        boolean bl = ((KeyEvent)object).getKeyCode() == (Environment.isWindows() ? 13 : 10);
        object = new ForwardKeyboardMessage(MessageUIDGenerator.generate(), n2, n3, bl, c2, l2, n32);
        if (!this.getChannel().isClosed()) {
            this.getChannel().send((Message)object);
        }
    }

    private static int a(KeyEvent keyEvent) {
        int n2 = 0;
        try {
            Field field = keyEvent.getClass().getDeclaredField("rawCode");
            field.setAccessible(true);
            n2 = (int)field.getLong(keyEvent);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            a.log(Level.SEVERE, "Failed to get native key code.", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.log(Level.SEVERE, "Failed to get native key code.", illegalAccessException);
        }
        return n2;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        this.h.invoke(new w(this, rectangle));
    }

    public void focus() {
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new FocusMessage(MessageUIDGenerator.generate()));
        }
    }

    public void unfocus() {
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new UnfocusMessage(MessageUIDGenerator.generate()));
        }
    }

    private void d() {
        try {
            LightWeightWidget lightWeightWidget = this;
            long l2 = Native.getInstance().getWindowHandle(lightWeightWidget);
            long l3 = SharedMemoryLibrary.getInstance().getScreenId(l2);
            if (!this.getChannel().isClosed()) {
                this.getChannel().send(new ScreenChangedMessage(MessageUIDGenerator.generate(), l3));
            }
            return;
        }
        catch (Exception exception) {
            a.severe("Failed to get and send screen id to Chromium. Cause: " + exception.getMessage());
            return;
        }
    }

    static /* synthetic */ void a(LightWeightWidget object, OnPaintMessage object22) {
        Object object2 = object22;
        long l2 = ((OnPaintMessage)object2).getPid();
        long l3 = ((OnPaintMessage)object2).getSharedMemoryHandle();
        int n2 = ((OnPaintMessage)object2).getSharedMemoryCapacity();
        int n3 = ((OnPaintMessage)object2).getClientWidth();
        int n4 = ((OnPaintMessage)object2).getClientHeight();
        int n5 = ((OnPaintMessage)object2).getRectX();
        int n6 = ((OnPaintMessage)object2).getRectY();
        int n7 = ((OnPaintMessage)object2).getRectWidth();
        int n8 = ((OnPaintMessage)object2).getRectHeight();
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        Dimension dimension = new Dimension(n3, n4);
        String string = ((OnPaintMessage)object2).getMemoryFilePath();
        double d2 = ((OnPaintMessage)object2).getDeviceScaleFactor();
        SharedMemory sharedMemory = new SharedMemory(l2, l3, n2, dimension, string, d2);
        ((LightWeightWidget)((Object)object)).c.updatePixels(sharedMemory, rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (Environment.isMac()) {
            rectangle2.x = (int)((double)rectangle2.x / d2);
            rectangle2.y = (int)((double)rectangle2.y / d2);
            rectangle2.width = (int)((double)rectangle2.width / d2);
            rectangle2.height = (int)((double)rectangle2.height / d2);
        }
        ((JComponent)((Object)object)).repaint(rectangle2);
        for (LightWeightWidgetListener lightWeightWidgetListener : ((LightWeightWidget)((Object)object)).getLightWeightWidgetListeners()) {
            lightWeightWidgetListener.onRepaint(rectangle, dimension);
        }
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnCursorChangeMessage onCursorChangeMessage) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        int n6 = onCursorChangeMessage.getCursorType();
        Cursor cursor = CursorType.toJavaCursor(n6, byArray = onCursorChangeMessage.getPixels(), n5 = onCursorChangeMessage.getWidth(), n4 = onCursorChangeMessage.getHeight(), n3 = onCursorChangeMessage.getHotspotX(), n2 = onCursorChangeMessage.getHotspotY());
        if (cursor != null) {
            SwingUtilities.invokeLater(new v(lightWeightWidget, cursor));
        }
    }

    static /* synthetic */ void a(OnTakeFocusMessage onTakeFocusMessage) {
        if (onTakeFocusMessage.isReverse()) {
            SwingUtilities.invokeLater(new t());
            return;
        }
        SwingUtilities.invokeLater(new u());
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnStartDraggingMessage object) {
        if (!lightWeightWidget.l.isDragAndDropEnabled()) {
            if (!lightWeightWidget.getChannel().isClosed()) {
                lightWeightWidget.getChannel().send(new DragEndedMessage(MessageUIDGenerator.generate()));
                return;
            }
        } else {
            object = new DragAndDropData(((OnStartDraggingMessage)object).getURL(), ((OnStartDraggingMessage)object).getURLTitle(), ((OnStartDraggingMessage)object).getText(), ((OnStartDraggingMessage)object).getHTML(), ((OnStartDraggingMessage)object).getCustomData(), ((OnStartDraggingMessage)object).getHTMLBaseURL());
            lightWeightWidget.l.setDragStarted(true);
            lightWeightWidget.l.setData((DragAndDropData)object);
        }
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnTooltipChangeMessage object) {
        object = ((OnTooltipChangeMessage)object).getTooltipText();
        SwingUtilities.invokeLater(new s(lightWeightWidget, (String)object));
    }

    static /* synthetic */ void a(LightWeightWidget object, OnShowPopupWidgetMessage object2) {
        int n2 = ((OnShowPopupWidgetMessage)object2).getChannelId();
        object2 = ((OnShowPopupWidgetMessage)object2).getPopupBounds();
        object = new LightWeightPopup((LightWeightWidget)object, n2, (Rectangle)object2);
        ((LightWeightPopup)object).show();
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnGetParentForWindowlessPluginMessage onGetParentForWindowlessPluginMessage) {
        if (Environment.isWindows()) {
            onGetParentForWindowlessPluginMessage.setHandle(Native.getInstance().getWindowHandle(lightWeightWidget));
        }
    }

    static final class b
    implements MacShortcutSupport<KeyEvent> {
        private final Browser a;

        b(Browser browser) {
            this.a = browser;
        }

        @Override
        public final /* synthetic */ void handleKeyPress(Object object) {
            Object object2 = (KeyEvent)object;
            object = this;
            if ((object2 = MacShortcutsCommandFactory.create(object2)) != null) {
                ((b)object).a.executeCommand(-2L, (EditorCommand)((Object)object2), null);
            }
        }
    }

    final class h
    extends DragSourceAdapter
    implements DropTargetListener {
        private boolean a;
        private boolean b;
        private /* synthetic */ LightWeightWidget c;

        private h(LightWeightWidget lightWeightWidget) {
            this.c = lightWeightWidget;
        }

        @Override
        public final void dragEnter(DropTargetDragEvent serializable) {
            if (!this.c.l.isDragAndDropEnabled()) {
                serializable.rejectDrag();
                return;
            }
            this.a(serializable.getTransferable());
            if (this.c.l.getData() == null) {
                serializable.rejectDrag();
                return;
            }
            this.a = true;
            this.b = false;
            Point point = this.c.getLocationOnScreen();
            serializable = serializable.getLocation();
            serializable = new Point(point.x + ((Point)serializable).x, point.y + ((Point)serializable).y);
            this.a((Point)serializable, this.c.l.getData());
        }

        @Override
        public final void dragExit(DropTargetEvent object) {
            DragAndDropData dragAndDropData = this.c.l.getData();
            boolean bl = this.a;
            object = this;
            if (bl && !((h)object).c.getChannel().isClosed()) {
                ((h)object).c.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragLeave, 0, 0, 0, 0, DragTargetMessage.WebDragOperation.WebDragOperationNone, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getCustomData(), dragAndDropData.getHTMLBaseURL()));
            }
            this.a = false;
            this.b = true;
        }

        @Override
        public final void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = this.c.getLocationOnScreen();
            Point point2 = dropTargetDropEvent.getLocation();
            point = new Point(point.x + point2.x, point.y + point2.y);
            if (Environment.isMac()) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                this.a(dropTargetDropEvent.getTransferable());
                this.a(point, this.c.l.getData());
            }
            this.a(point, this.a, this.c.l.getData());
            dropTargetDropEvent.dropComplete(true);
            this.a = false;
        }

        @Override
        public final void dragOver(DropTargetDragEvent object) {
            Serializable serializable = this.c.getLocationOnScreen();
            object = ((DropTargetDragEvent)object).getLocation();
            object = new Point(serializable.x + ((Point)object).x, serializable.y + ((Point)object).y);
            DragAndDropData dragAndDropData = this.c.l.getData();
            boolean bl = this.a;
            serializable = object;
            object = this;
            if (bl) {
                Point point = ((h)object).c.getLocationOnScreen();
                int n2 = serializable.x - point.x;
                int n3 = serializable.y - point.y;
                int n4 = serializable.x;
                int n5 = serializable.y;
                if (Environment.isWindows()) {
                    double d2 = ((h)object).c.c.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d2);
                    n3 = (int)((double)n3 / d2);
                    n4 = (int)((double)n4 / d2);
                    n5 = (int)((double)n5 / d2);
                }
                DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
                if (!((h)object).c.getChannel().isClosed()) {
                    ((h)object).c.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragOver, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getCustomData(), dragAndDropData.getHTMLBaseURL()));
                }
            }
        }

        private void a(Transferable object) {
            object = new TransferableWrapper((Transferable)object);
            this.c.l.setData(new DragAndDropData(((TransferableWrapper)object).getURL(), "", ((TransferableWrapper)object).getText(), ((TransferableWrapper)object).getHTML(), ((TransferableWrapper)object).getCustomData(), ""));
        }

        private void a(Point point, DragAndDropData dragAndDropData) {
            Point point2 = this.c.getLocationOnScreen();
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            int n4 = point.x;
            int n5 = point.y;
            if (Environment.isWindows()) {
                double d2 = this.c.c.getDeviceScaleFactor();
                n2 = (int)((double)n2 / d2);
                n3 = (int)((double)n3 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (!this.c.getChannel().isClosed()) {
                this.c.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragEnter, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getCustomData(), dragAndDropData.getHTMLBaseURL()));
            }
        }

        private void a(Point point, boolean bl, DragAndDropData dragAndDropData) {
            int n2 = 0;
            int n3 = 0;
            int n4 = point.x;
            int n5 = point.y;
            if (Environment.isWindows()) {
                double d2 = this.c.c.getDeviceScaleFactor();
                n3 = n2 = (int)(0.0 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (bl) {
                Point point2 = this.c.getLocationOnScreen();
                n2 = point.x - point2.x;
                n3 = point.y - point2.y;
                if (Environment.isWindows()) {
                    double d3 = this.c.c.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d3);
                    n3 = (int)((double)n3 / d3);
                }
                if (!this.c.getChannel().isClosed()) {
                    this.c.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDrop, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getCustomData(), dragAndDropData.getHTMLBaseURL()));
                }
            }
            if (!this.c.getChannel().isClosed()) {
                this.c.getChannel().send(new DragEndedMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, webDragOperation.ordinal()));
            }
            this.c.l.setData(null);
        }

        @Override
        public final void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (this.b) {
                this.a(dragSourceDropEvent.getLocation(), this.a, this.c.l.getData());
            }
        }

        @Override
        public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        /* synthetic */ h(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class c
    implements ChannelListener {
        private /* synthetic */ LightWeightWidget a;

        private c(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnPaint) {
                LightWeightWidget.a(this.a, (OnPaintMessage)message);
                return;
            }
            if (messageType == MessageType.OnCursorChange) {
                LightWeightWidget.a(this.a, (OnCursorChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnRenderViewGone) {
                this.a.b();
                return;
            }
            if (messageType == MessageType.OnRenderViewCreated) {
                this.a.c();
                return;
            }
            if (messageType == MessageType.OnTakeFocus) {
                LightWeightWidget.a((OnTakeFocusMessage)message);
                return;
            }
            if (messageType == MessageType.OnStartDragging) {
                LightWeightWidget.a(this.a, (OnStartDraggingMessage)message);
                return;
            }
            if (messageType == MessageType.OnTooltipChange) {
                LightWeightWidget.a(this.a, (OnTooltipChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnShowPopupWidget) {
                LightWeightWidget.a(this.a, (OnShowPopupWidgetMessage)message);
                return;
            }
            if (messageType == MessageType.OnGetParentForWindowlessPlugin) {
                LightWeightWidget.a(this.a, (OnGetParentForWindowlessPluginMessage)message);
            }
        }

        /* synthetic */ c(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class a
    extends IPCChannelAdapter {
        private /* synthetic */ LightWeightWidget a;

        private a(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void onChannelRemoved(Channel channel) {
            boolean bl;
            Channel channel2 = this.a.getChannel();
            boolean bl2 = channel.getChannelId() == channel2.getChannelId();
            boolean bl3 = bl = channel.getType() == channel2.getType();
            if (bl2 && bl) {
                this.a.b();
            }
        }

        /* synthetic */ a(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class d
    extends FocusAdapter {
        private /* synthetic */ LightWeightWidget a;

        private d(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void focusGained(FocusEvent focusEvent) {
            this.a.focus();
        }

        @Override
        public final void focusLost(FocusEvent focusEvent) {
            this.a.unfocus();
        }

        /* synthetic */ d(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class g
    extends ComponentAdapter {
        private /* synthetic */ LightWeightWidget a;

        private g(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void componentResized(ComponentEvent serializable) {
            if ((serializable = ((ComponentEvent)serializable).getComponent()) != null) {
                serializable = ((Component)serializable).getBounds();
                this.a.setBounds((Rectangle)serializable);
            }
        }

        /* synthetic */ g(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class e
    extends KeyAdapter {
        private /* synthetic */ LightWeightWidget a;

        private e(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void keyPressed(KeyEvent keyEvent) {
            if (this.b(keyEvent)) {
                this.a.forwardKeyPressedEvent(keyEvent);
                this.a(keyEvent);
            }
            if (this.a.s != null) {
                this.a.s.handleKeyPress(keyEvent);
            }
        }

        @Override
        public final void keyTyped(KeyEvent keyEvent) {
            if (this.b(keyEvent)) {
                this.a.forwardKeyTypedEvent(keyEvent);
                this.a(keyEvent);
            }
        }

        @Override
        public final void keyReleased(KeyEvent keyEvent) {
            if (this.b(keyEvent)) {
                this.a.forwardKeyReleasedEvent(keyEvent);
                this.a(keyEvent);
            }
        }

        private void a(KeyEvent keyEvent) {
            Container container = this.a.getParent();
            if (container != null) {
                container.dispatchEvent(keyEvent);
            }
        }

        private boolean b(KeyEvent keyEvent) {
            boolean bl = keyEvent.getKeyChar() == '\n';
            boolean bl2 = keyEvent.getID() == 400;
            if (bl2 && bl && this.a.p) {
                return false;
            }
            if (this.a.q != null) {
                try {
                    return !this.a.q.handle(keyEvent);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The KeyEventsHandler.handle() method has thrown exception: ", exception);
                }
            }
            return true;
        }

        /* synthetic */ e(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class f
    extends MouseAdapter {
        private /* synthetic */ LightWeightWidget a;

        private f(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void mousePressed(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
                this.a.forwardMouseEvent(mouseEvent);
            }
            this.a.requestFocus();
        }

        @Override
        public final void mouseReleased(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
                this.a.forwardMouseEvent(mouseEvent);
            }
        }

        @Override
        public final void mouseEntered(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
                this.a.forwardMouseEvent(mouseEvent);
            }
        }

        @Override
        public final void mouseClicked(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
            }
        }

        @Override
        public final void mouseMoved(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
            }
        }

        @Override
        public final void mouseDragged(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
            }
        }

        @Override
        public final void mouseExited(MouseEvent mouseEvent) {
            if (this.a.a(mouseEvent)) {
                this.a(mouseEvent);
                this.a.forwardMouseEvent(mouseEvent);
            }
        }

        @Override
        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (this.a.a(mouseWheelEvent)) {
                this.a(mouseWheelEvent);
                this.a.forwardMouseWheelEvent(mouseWheelEvent);
            }
            mouseWheelEvent.consume();
        }

        private void a(MouseEvent mouseEvent) {
            Container container = this.a.getParent();
            if (container != null) {
                container.dispatchEvent(mouseEvent);
            }
        }

        /* synthetic */ f(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class i
    extends ComponentAdapter {
        private /* synthetic */ LightWeightWidget a;

        private i(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void componentMoved(ComponentEvent componentEvent) {
            this.a.d();
        }

        /* synthetic */ i(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }
}

