/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.modules.taskmanager;

import com.agilemind.commons.modules.taskmanager.Task;
import com.agilemind.commons.modules.taskmanager.TaskId;
import com.agilemind.commons.modules.taskmanager.TaskManagerSnapshot;
import com.agilemind.commons.modules.taskmanager.listener.TaskAddedListener;
import com.agilemind.commons.modules.taskmanager.listener.TaskChangedListener;
import com.agilemind.commons.modules.taskmanager.listener.TaskRemovedListener;
import com.agilemind.commons.util.Pair;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface TaskManager<T extends Task> {
    public void addTask(Function<TaskId, T> var1);

    public void removeTask(TaskId var1, Predicate<T> var2);

    public void clearQueue();

    public void moveTaskInQueue(int var1, TaskId var2);

    public TaskManagerSnapshot<T> getSnapshot();

    default public Stream<T> getMergedSnapshotList() {
        TaskManagerSnapshot<T> taskManagerSnapshot = this.getSnapshot();
        return Stream.concat(taskManagerSnapshot.getQueue().stream(), taskManagerSnapshot.getActiveMap().keySet().stream());
    }

    default public Pair<Integer, Integer> getActiveAndQueueSize() {
        TaskManagerSnapshot<T> taskManagerSnapshot = this.getSnapshot();
        return Pair.create((Object)taskManagerSnapshot.getActiveMap().size(), (Object)taskManagerSnapshot.getQueue().size());
    }

    default public boolean hasTasks() {
        TaskManagerSnapshot<T> taskManagerSnapshot = this.getSnapshot();
        return !taskManagerSnapshot.getActiveMap().isEmpty() || !taskManagerSnapshot.getQueue().isEmpty();
    }

    default public void removeTasks(Predicate<T> predicate) {
        TaskManagerSnapshot<T> taskManagerSnapshot = this.getSnapshot();
        taskManagerSnapshot.getQueue().forEach(task -> this.removeTask(task.id(), predicate));
        taskManagerSnapshot.getActiveMap().keySet().forEach(task -> this.removeTask(task.id(), predicate));
    }

    public void addTaskChangedListener(TaskChangedListener<? super T> var1);

    public void removeTaskChangedListener(TaskChangedListener<? super T> var1);

    public void addTaskAddedListener(TaskAddedListener<? super T> var1);

    public void removeTaskAddedListener(TaskAddedListener<? super T> var1);

    public void addTaskRemovedListener(TaskRemovedListener<? super T> var1);

    public void removeTaskRemovedListener(TaskRemovedListener<? super T> var1);

    public void commitLock(boolean var1);
}

