/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.data.field.types;

import com.agilemind.commons.data.Deserializer;
import com.agilemind.commons.data.field.types.StringBufferDeserializer;
import com.agilemind.commons.data.field.types.Type;
import com.agilemind.commons.data.util.StringUtil;
import com.agilemind.commons.data.value.DirectValue;
import com.agilemind.commons.data.value.Value;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ElementalType<R>
extends Type<R> {
    private static final List<ElementalType<?>> a = new ArrayList();
    private static final Map<String, ElementalType<?>> c = new HashMap();

    protected ElementalType() {
        this(true);
    }

    protected ElementalType(boolean bl) {
        if (bl) {
            a.add(this);
        }
    }

    public abstract String getDescription();

    public static Collection<ElementalType<?>> getTypes() {
        return Collections.unmodifiableCollection(a);
    }

    public static ElementalType<?> getType(String string) {
        ElementalType elementalType2 = c.get(string);
        if (elementalType2 == null) {
            elementalType2 = a.stream().filter(elementalType -> elementalType.getDescription().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException(string));
        }
        return elementalType2;
    }

    public static <T> ElementalType<T> getType(Class<T> clazz) {
        boolean bl = Type.b;
        for (ElementalType<?> elementalType : a) {
            if (elementalType.getFieldClass() == clazz) {
                return elementalType;
            }
            if (!bl) continue;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public void writeTo(Writer writer, R r2) throws IOException {
        String string = this.serialize(r2);
        string = StringUtil.removeHTMLSpecialCharacters(string);
        string = StringUtil.removeXMLSpecialCharacters(string);
        string = StringUtil.removeHTMLSpecialCharacters(string);
        writer.write(string);
    }

    public abstract String serialize(R var1) throws IOException;

    public abstract R deserialize(String var1) throws IOException;

    public R deserializeFromCSV(String string) throws IOException {
        return this.deserialize(string);
    }

    public Deserializer getDeserializer() {
        return new StringBufferDeserializer(this);
    }

    public void writeTo(DataOutput dataOutput, R r2) throws IOException {
        dataOutput.writeUTF(this.serialize(r2));
    }

    public R read(DataInput dataInput) throws IOException {
        return this.deserialize(dataInput.readUTF());
    }

    public Value<R> readFrom(DataInput dataInput) throws IOException {
        return new DirectValue<R>(this.read(dataInput));
    }
}

