/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.data.util;

import com.agilemind.commons.data.field.Field;
import com.agilemind.commons.data.util.StringUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Braf2
implements DataInput,
DataOutput,
AutoCloseable {
    private static final Logger a;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected String location;
    protected RandomAccessFile file;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected boolean readonly;
    protected boolean bigEndian;
    boolean b = false;
    private long c = 0L;
    boolean d = false;
    protected boolean cached;
    private static final String[] e;

    protected Braf2(int n2) {
        this.file = null;
        this.readonly = true;
        this.a(n2);
    }

    public Braf2(String string, String string2) throws IOException {
        this(string, string2, 8192);
    }

    public Braf2(String string, String string2, int n2) throws IOException {
        this.location = string;
        this.file = new RandomAccessFile(string, string2);
        this.readonly = string2.equals("r");
        this.a(n2);
        a.debug(e[8]);
    }

    private void a(int n2) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[n2];
        this.endOfFile = false;
    }

    @Override
    public void close() throws IOException {
        block14: {
            block13: {
                if (this.file == null) {
                    return;
                }
                if (this.readonly || !this.b) break block13;
                this.file.seek(this.bufferStart);
                this.file.write(this.buffer, 0, this.dataSize);
            }
            if (this.readonly || this.c == 0L) break block14;
            if (this.c == this.file.length()) break block14;
            this.file.setLength(this.c);
        }
        this.file.close();
        this.file = null;
        a.debug(e[7]);
    }

    public boolean isAtEndOfFile() {
        return this.endOfFile;
    }

    public FileChannel getChannel() {
        if (this.file == null) {
            return null;
        }
        try {
            this.file.seek(0L);
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
        }
        return this.file.getChannel();
    }

    public void seek(long l2) throws IOException {
        block13: {
            block12: {
                block11: {
                    if (l2 < this.bufferStart || l2 >= this.dataEnd) break block11;
                    this.filePosition = l2;
                    return;
                }
                if (this.b) {
                    this.flush();
                }
                this.bufferStart = l2;
                this.filePosition = l2;
                this.dataSize = this.read_(l2, this.buffer, 0, this.buffer.length);
                if (this.dataSize > 0) break block12;
                this.dataSize = 0;
                this.endOfFile = true;
                if (StringUtil.b == 0) break block13;
            }
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public String getLocation() {
        return this.location;
    }

    public long length() throws IOException {
        long l2 = this.file.length();
        if (l2 < this.dataEnd) {
            return this.dataEnd;
        }
        return l2;
    }

    public void order(int n2) {
        this.bigEndian = n2 == 0;
    }

    public FileDescriptor getFD() throws IOException {
        FileDescriptor fileDescriptor = this.file != null ? this.file.getFD() : null;
        return fileDescriptor;
    }

    public void flush() throws IOException {
        if (this.b) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.b = false;
        }
    }

    public void setMinLength(long l2) {
        this.c = l2;
    }

    public void setExtendMode() {
        this.d = true;
    }

    public int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            int n2 = (int)(this.filePosition - this.bufferStart);
            ++this.filePosition;
            return this.buffer[n2] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readBytes(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block13: {
            int n5;
            block15: {
                block16: {
                    int n6;
                    block14: {
                        n6 = StringUtil.b;
                        if (this.endOfFile) {
                            return -1;
                        }
                        int n7 = (int)(this.dataEnd - this.filePosition);
                        if (n7 < 1) {
                            this.seek(this.filePosition);
                            return this.readBytes(byArray, n2, n3);
                        }
                        n4 = n7 < n3 ? n7 : n3;
                        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), byArray, n2, n4);
                        this.filePosition += (long)n4;
                        if (n4 >= n3) break block13;
                        n5 = n3 - n4;
                        if (n5 <= this.buffer.length) break block14;
                        n5 = this.read_(this.filePosition, byArray, n2 + n4, n3 - n4);
                        if (n6 == 0) break block15;
                    }
                    this.seek(this.filePosition);
                    if (!this.endOfFile) break block16;
                    n5 = -1;
                    if (n6 == 0) break block15;
                }
                n5 = n5 <= this.dataSize ? n5 : this.dataSize;
                System.arraycopy(this.buffer, 0, byArray, n2 + n4, n5);
            }
            if (n5 > 0) {
                this.filePosition += (long)n5;
                return n4 + n5;
            }
        }
        return n4;
    }

    protected int read_(long l2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block2: {
            this.file.seek(l2);
            n4 = this.file.read(byArray, n2, n3);
            if (!this.d || n4 >= n3) break block2;
            n4 = n3;
        }
        return n4;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.readBytes(byArray, n2, n3);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = StringUtil.b;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = this.read(byArray, n2 + i2, n3 - i2);
            if (n4 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        this.seek(this.getFilePointer() + (long)n2);
        return n2;
    }

    public void unread() {
        --this.filePosition;
    }

    @Override
    public void write(int n2) throws IOException {
        block9: {
            block10: {
                int n3;
                block8: {
                    n3 = StringUtil.b;
                    if (this.filePosition >= this.dataEnd) break block8;
                    this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)n2;
                    this.b = true;
                    if (n3 == 0) break block9;
                }
                if (this.dataSize == this.buffer.length) break block10;
                this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)n2;
                this.b = true;
                ++this.dataSize;
                ++this.dataEnd;
                if (n3 == 0) break block9;
            }
            this.seek(this.filePosition);
            this.write(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        block14: {
            block13: {
                long l2;
                if (n3 >= this.buffer.length) break block13;
                int n4 = 0;
                if (this.filePosition >= this.bufferStart) {
                    n4 = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
                }
                int n5 = 0;
                if (n4 > 0) {
                    n5 = n4 <= n3 ? n4 : n3;
                    System.arraycopy(byArray, n2, this.buffer, (int)(this.filePosition - this.bufferStart), n5);
                    this.b = true;
                    l2 = this.filePosition + (long)n5;
                    this.dataEnd = l2 <= this.dataEnd ? this.dataEnd : l2;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)n5;
                }
                if (n5 < n3) {
                    this.seek(this.filePosition);
                    System.arraycopy(byArray, n2 + n5, this.buffer, (int)(this.filePosition - this.bufferStart), n3 - n5);
                    this.b = true;
                    l2 = this.filePosition + (long)(n3 - n5);
                    this.dataEnd = l2 <= this.dataEnd ? this.dataEnd : l2;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)(n3 - n5);
                }
                if (StringUtil.b == 0) break block14;
            }
            if (this.b) {
                this.flush();
                this.dataSize = 0;
                this.bufferStart = this.dataEnd = (long)0;
            }
            this.file.seek(this.filePosition);
            this.file.write(byArray, n2, n3);
            this.filePosition += (long)n3;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.writeBytes(byArray, n2, n3);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        boolean bl = n2 != 0;
        return bl;
    }

    @Override
    public final byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public final short readShort() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        if ((n2 | n3) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (short)((n2 << 8) + n3);
        }
        return (short)((n3 << 8) + n2);
    }

    public final void readShort(short[] sArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray[n2 + i2] = this.readShort();
            if (n4 == 0) continue;
        }
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        if ((n2 | n3) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n2 << 8) + n3;
        }
        return (n3 << 8) + n2;
    }

    @Override
    public final char readChar() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        if ((n2 | n3) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (char)((n2 << 8) + n3);
        }
        return (char)((n3 << 8) + n2);
    }

    @Override
    public final int readInt() throws IOException {
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        int n5 = this.read();
        if ((n2 | n3 | n4 | n5) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
    }

    public final int readIntUnbuffered(long l2) throws IOException {
        int n2 = StringUtil.b;
        byte[] byArray = new byte[4];
        this.read_(l2, byArray, 0, 4);
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[2] & 0xFF;
        int n6 = byArray[3] & 0xFF;
        if ((n3 | n4 | n5 | n6) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
        }
        int n7 = (n6 << 24) + (n5 << 16) + (n4 << 8) + n3;
        if (Field.c != 0) {
            StringUtil.b = ++n2;
        }
        return n7;
    }

    public final void readInt(int[] nArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[n2 + i2] = this.readInt();
            if (n4 == 0) continue;
        }
    }

    @Override
    public final long readLong() throws IOException {
        if (this.bigEndian) {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) + ((long)this.readInt() << 32);
    }

    public final void readLong(long[] lArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray[n2 + i2] = this.readLong();
            if (n4 == 0) continue;
        }
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFloat(float[] fArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray[n2 + i2] = Float.intBitsToFloat(this.readInt());
            if (n4 == 0) continue;
        }
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void readDouble(double[] dArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[n2 + i2] = Double.longBitsToDouble(this.readLong());
            if (n4 == 0) continue;
        }
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder stringBuilder;
        block7: {
            int n2;
            int n3 = StringUtil.b;
            stringBuilder = new StringBuilder();
            while ((n2 = this.read()) != -1) {
                if (n2 == 10) break;
                stringBuilder.append((char)n2);
                if (n3 == 0) continue;
                break;
            }
            if (n2 != -1 || stringBuilder.length() != 0) break block7;
            return null;
        }
        return stringBuilder.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readString(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return new String(byArray);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        Braf2 braf2 = this;
        int n2 = bl ? 1 : 0;
        braf2.write(n2);
    }

    public final void writeBoolean(boolean[] blArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeBoolean(blArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    @Override
    public final void writeShort(int n2) throws IOException {
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 & 0xFF);
    }

    public final void writeShort(short[] sArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeShort(sArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeChar(int n2) throws IOException {
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 & 0xFF);
    }

    public final void writeChar(char[] cArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeChar(cArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeInt(int n2) throws IOException {
        this.write(n2 >>> 24 & 0xFF);
        this.write(n2 >>> 16 & 0xFF);
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 & 0xFF);
    }

    public final void writeInt(int[] nArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeInt(nArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeLong(long l2) throws IOException {
        int n2 = StringUtil.b;
        this.write((int)(l2 >>> 56) & 0xFF);
        this.write((int)(l2 >>> 48) & 0xFF);
        this.write((int)(l2 >>> 40) & 0xFF);
        this.write((int)(l2 >>> 32) & 0xFF);
        this.write((int)(l2 >>> 24) & 0xFF);
        this.write((int)(l2 >>> 16) & 0xFF);
        this.write((int)(l2 >>> 8) & 0xFF);
        this.write((int)l2 & 0xFF);
        if (n2 != 0) {
            int n3 = Field.c;
            Field.c = ++n3;
        }
    }

    public final void writeLong(long[] lArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeLong(lArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeFloat(float[] fArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeFloat(fArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeDouble(double[] dArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.writeDouble(dArray[n2 + i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n2 = StringUtil.b;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write((byte)string.charAt(i2));
            if (n2 == 0) continue;
        }
    }

    public final void writeBytes(char[] cArray, int n2, int n3) throws IOException {
        int n4 = StringUtil.b;
        for (int i2 = n2; i2 < n3; ++i2) {
            this.write((byte)cArray[i2]);
            if (n4 == 0) continue;
        }
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n2 = StringUtil.b;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            this.write(c2 >>> 8 & 0xFF);
            this.write(c2 & 0xFF);
            if (n2 == 0) continue;
        }
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        char c2;
        int n2;
        int n3 = StringUtil.b;
        int n4 = string.length();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            block26: {
                block25: {
                    c2 = string.charAt(n2);
                    if (c2 < '\u0001' || c2 > '\u007f') break block25;
                    ++n5;
                    if (n3 == 0) continue;
                }
                if (c2 <= '\u07ff') break block26;
                n5 += 3;
                if (n3 == 0) continue;
            }
            n5 += 2;
            continue;
        }
        if (n5 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n5 >>> 8 & 0xFF);
        this.write(n5 & 0xFF);
        for (n2 = 0; n2 < n4; ++n2) {
            block28: {
                block27: {
                    c2 = string.charAt(n2);
                    if (c2 < '\u0001' || c2 > '\u007f') break block27;
                    this.write(c2);
                    if (n3 == 0) continue;
                }
                if (c2 <= '\u07ff') break block28;
                this.write(0xE0 | c2 >> 12 & 0xF);
                this.write(0x80 | c2 >> 6 & 0x3F);
                this.write(0x80 | c2 & 0x3F);
                if (n3 == 0) continue;
            }
            this.write(0xC0 | c2 >> 6 & 0x1F);
            this.write(0x80 | c2 & 0x3F);
            continue;
        }
    }

    public String toString() {
        return e[2] + this.filePosition + e[3] + this.bufferStart + e[4] + this.dataEnd + e[5] + this.dataSize + e[1] + this.buffer.length + e[6] + this.readonly + e[0] + this.b;
    }

    public void setCached(boolean bl) {
        this.cached = bl;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void synch() throws IOException {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0003T-4\u0001";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 47;
                                break;
                            }
                            case 1: {
                                n9 = 116;
                                break;
                            }
                            case 2: {
                                n9 = 79;
                                break;
                            }
                            case 3: {
                                n9 = 89;
                                break;
                            }
                            default: {
                                n9 = 60;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0003T-5\u0001";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "I\u0004r";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0003T-*\u0001";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0003T+<\u0001";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0003T+*\u0001";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0003T=<]K\u001b!5E\u0012";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "k\u0015;8~N\u0007*y_C\u001b<<X";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "k\u0015;8~N\u0007*y_]\u0011.-YK";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        e = stringArray3;
        a = LoggerFactory.getLogger(Braf2.class);
    }
}

