/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.backlinks;

import com.agilemind.backlinks.BackLinkSourceList;
import com.agilemind.backlinks.BackLinkSourceType;
import com.agilemind.backlinks.IBackLinkSourceSettings;
import com.agilemind.backlinks.analytics.GoogleAnalyticsBackLinkSource;
import com.agilemind.backlinks.blex.WebMeUpBackLinkSource;
import com.agilemind.backlinks.gsc.GoogleSearchConsoleBackLinkSource;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class BackLinkSourceListImpl
extends BackLinkSourceList {
    private Set<BackLinkSourceType> c = new LinkedHashSet<BackLinkSourceType>();

    public BackLinkSourceListImpl() {
        this.c.add(WEBMEUP_BACKLINK_SOURCE_TYPE);
        this.c.add(ANALYTICS_BACKLINK_SOURCE_TYPE);
        this.c.add(GOOGLE_SEARCH_CONSOLE_BACKLINK_SOURCE);
    }

    @Override
    public Collection<BackLinkSourceType> getBackLinkSourceTypes() {
        return this.c;
    }

    protected GoogleAnalyticsBackLinkSource createAnalyticsBacklinkSource(IBackLinkSourceSettings iBackLinkSourceSettings) {
        return new GoogleAnalyticsBackLinkSource(iBackLinkSourceSettings.getGoogleAnalyticsSettings());
    }

    protected WebMeUpBackLinkSource createWebmeupBacklinkSource(IBackLinkSourceSettings iBackLinkSourceSettings) {
        return new WebMeUpBackLinkSource(iBackLinkSourceSettings.getServerRequestInfo());
    }

    protected GoogleSearchConsoleBackLinkSource createGoogleSearchConsoleBacklinkSource(IBackLinkSourceSettings iBackLinkSourceSettings) {
        return new GoogleSearchConsoleBackLinkSource(iBackLinkSourceSettings.getGoogleSearchConsoleSettings());
    }
}

