/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageFilterException;
import com.twelvemonkeys.image.IndexImage;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Random;

public class DiffusionDither
implements BufferedImageOp,
RasterOp {
    protected IndexColorModel mIndexColorModel = null;
    private boolean mAlternateScans = true;
    private static final int FS_SCALE = 256;
    private static final Random RANDOM = new Random();

    public DiffusionDither(IndexColorModel pICM) {
        this.mIndexColorModel = pICM;
    }

    public DiffusionDither() {
    }

    public void setAlternateScans(boolean pUse) {
        this.mAlternateScans = pUse;
    }

    public final BufferedImage createCompatibleDestImage(BufferedImage pSource, ColorModel pDestCM) {
        if (pDestCM == null) {
            return new BufferedImage(pSource.getWidth(), pSource.getHeight(), 13, this.getICM(pSource));
        }
        if (pDestCM instanceof IndexColorModel) {
            return new BufferedImage(pSource.getWidth(), pSource.getHeight(), 13, (IndexColorModel)pDestCM);
        }
        throw new ImageFilterException("Only IndexColorModel allowed.");
    }

    public final WritableRaster createCompatibleDestRaster(Raster pSrc) {
        return this.createCompatibleDestRaster(pSrc, this.getICM(pSrc));
    }

    public final WritableRaster createCompatibleDestRaster(Raster pSrc, IndexColorModel pIndexColorModel) {
        return pIndexColorModel.createCompatibleWritableRaster(pSrc.getWidth(), pSrc.getHeight());
    }

    public final Rectangle2D getBounds2D(BufferedImage pSrc) {
        return this.getBounds2D(pSrc.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster pSrc) {
        return pSrc.getBounds();
    }

    public final Point2D getPoint2D(Point2D pSrcPt, Point2D pDstPt) {
        if (pDstPt == null) {
            pDstPt = new Point2D.Float();
        }
        pDstPt.setLocation(pSrcPt.getX(), pSrcPt.getY());
        return pDstPt;
    }

    public final RenderingHints getRenderingHints() {
        return null;
    }

    private static int[] toRGBArray(int pARGB, int[] pBuffer) {
        pBuffer[0] = (pARGB & 0xFF0000) >> 16;
        pBuffer[1] = (pARGB & 0xFF00) >> 8;
        pBuffer[2] = pARGB & 0xFF;
        return pBuffer;
    }

    private static int toIntARGB(int[] pRGB) {
        return 0xFF000000 | pRGB[0] << 16 | pRGB[1] << 8 | pRGB[2];
    }

    public final BufferedImage filter(BufferedImage pSource, BufferedImage pDest) {
        if (pDest == null) {
            pDest = this.createCompatibleDestImage(pSource, this.getICM(pSource));
        } else if (!(pDest.getColorModel() instanceof IndexColorModel)) {
            throw new ImageFilterException("Only IndexColorModel allowed.");
        }
        this.filter(pSource.getRaster(), pDest.getRaster(), (IndexColorModel)pDest.getColorModel());
        return pDest;
    }

    public final WritableRaster filter(Raster pSource, WritableRaster pDest) {
        return this.filter(pSource, pDest, this.getICM(pSource));
    }

    private IndexColorModel getICM(BufferedImage pSource) {
        return this.mIndexColorModel != null ? this.mIndexColorModel : IndexImage.getIndexColorModel((Image)pSource, 256, 131072);
    }

    private IndexColorModel getICM(Raster pSource) {
        return this.mIndexColorModel != null ? this.mIndexColorModel : this.createIndexColorModel(pSource);
    }

    private IndexColorModel createIndexColorModel(Raster pSource) {
        BufferedImage image = new BufferedImage(pSource.getWidth(), pSource.getHeight(), 2);
        image.setData(pSource);
        return IndexImage.getIndexColorModel((Image)image, 256, 131072);
    }

    public final WritableRaster filter(Raster pSource, WritableRaster pDest, IndexColorModel pColorModel) {
        int width = pSource.getWidth();
        int height = pSource.getHeight();
        if (pDest == null) {
            pDest = this.createCompatibleDestRaster(pSource, pColorModel);
        }
        int[][] mCurrErr = new int[width + 2][3];
        int[][] mNextErr = new int[width + 2][3];
        for (int i = 0; i < width + 2; ++i) {
            mCurrErr[i][0] = RANDOM.nextInt(512) - 256;
            mCurrErr[i][1] = RANDOM.nextInt(512) - 256;
            mCurrErr[i][2] = RANDOM.nextInt(512) - 256;
        }
        int[] diff = new int[3];
        int[] inRGB = new int[4];
        int[] outRGB = new int[4];
        Object pixel = null;
        boolean forward = true;
        for (int y = 0; y < height; ++y) {
            int limit;
            int x;
            int i = mNextErr.length;
            while (--i >= 0) {
                mNextErr[i][0] = 0;
                mNextErr[i][1] = 0;
                mNextErr[i][2] = 0;
            }
            if (forward) {
                x = 0;
                limit = width;
            } else {
                x = width - 1;
                limit = -1;
            }
            while (true) {
                pSource.getPixel(x, y, inRGB);
                for (int i2 = 0; i2 < 3; ++i2) {
                    inRGB[i2] = (inRGB[i2] << 4) + mCurrErr[x + 1][i2] + 8 >> 4;
                    if (inRGB[i2] > 255) {
                        inRGB[i2] = 255;
                        continue;
                    }
                    if (inRGB[i2] >= 0) continue;
                    inRGB[i2] = 0;
                }
                pixel = pColorModel.getDataElements(DiffusionDither.toIntARGB(inRGB), pixel);
                pDest.setDataElements(x, y, pixel);
                pDest.getPixel(x, y, outRGB);
                DiffusionDither.toRGBArray(pColorModel.getRGB(outRGB[0]), outRGB);
                diff[0] = inRGB[0] - outRGB[0];
                diff[1] = inRGB[1] - outRGB[1];
                diff[2] = inRGB[2] - outRGB[2];
                if (forward) {
                    int[] nArray = mCurrErr[x + 2];
                    nArray[0] = nArray[0] + diff[0] * 7;
                    int[] nArray2 = mCurrErr[x + 2];
                    nArray2[1] = nArray2[1] + diff[1] * 7;
                    int[] nArray3 = mCurrErr[x + 2];
                    nArray3[2] = nArray3[2] + diff[2] * 7;
                    int[] nArray4 = mNextErr[x];
                    nArray4[0] = nArray4[0] + diff[0] * 3;
                    int[] nArray5 = mNextErr[x];
                    nArray5[1] = nArray5[1] + diff[1] * 3;
                    int[] nArray6 = mNextErr[x];
                    nArray6[2] = nArray6[2] + diff[2] * 3;
                    int[] nArray7 = mNextErr[x + 1];
                    nArray7[0] = nArray7[0] + diff[0] * 5;
                    int[] nArray8 = mNextErr[x + 1];
                    nArray8[1] = nArray8[1] + diff[1] * 5;
                    int[] nArray9 = mNextErr[x + 1];
                    nArray9[2] = nArray9[2] + diff[2] * 5;
                    int[] nArray10 = mNextErr[x + 2];
                    nArray10[0] = nArray10[0] + diff[0];
                    int[] nArray11 = mNextErr[x + 2];
                    nArray11[1] = nArray11[1] + diff[1];
                    int[] nArray12 = mNextErr[x + 2];
                    nArray12[2] = nArray12[2] + diff[2];
                    if (++x < limit) continue;
                    break;
                }
                int[] nArray = mCurrErr[x];
                nArray[0] = nArray[0] + diff[0] * 7;
                int[] nArray13 = mCurrErr[x];
                nArray13[1] = nArray13[1] + diff[1] * 7;
                int[] nArray14 = mCurrErr[x];
                nArray14[2] = nArray14[2] + diff[2] * 7;
                int[] nArray15 = mNextErr[x + 2];
                nArray15[0] = nArray15[0] + diff[0] * 3;
                int[] nArray16 = mNextErr[x + 2];
                nArray16[1] = nArray16[1] + diff[1] * 3;
                int[] nArray17 = mNextErr[x + 2];
                nArray17[2] = nArray17[2] + diff[2] * 3;
                int[] nArray18 = mNextErr[x + 1];
                nArray18[0] = nArray18[0] + diff[0] * 5;
                int[] nArray19 = mNextErr[x + 1];
                nArray19[1] = nArray19[1] + diff[1] * 5;
                int[] nArray20 = mNextErr[x + 1];
                nArray20[2] = nArray20[2] + diff[2] * 5;
                int[] nArray21 = mNextErr[x];
                nArray21[0] = nArray21[0] + diff[0];
                int[] nArray22 = mNextErr[x];
                nArray22[1] = nArray22[1] + diff[1];
                int[] nArray23 = mNextErr[x];
                nArray23[2] = nArray23[2] + diff[2];
                if (--x <= limit) break;
            }
            int[][] temperr = mCurrErr;
            mCurrErr = mNextErr;
            mNextErr = temperr;
            if (!this.mAlternateScans) continue;
            forward = !forward;
        }
        return pDest;
    }
}

