/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.SeekableInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileSeekableStream
extends SeekableInputStream {
    final RandomAccessFile mRandomAccess;

    public FileSeekableStream(File pInput) throws FileNotFoundException {
        this(new RandomAccessFile(pInput, "r"));
    }

    public FileSeekableStream(RandomAccessFile pInput) {
        this.mRandomAccess = pInput;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int available() throws IOException {
        long length = this.mRandomAccess.length() - this.mPosition;
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    public void closeImpl() throws IOException {
        this.mRandomAccess.close();
    }

    public int read() throws IOException {
        this.checkOpen();
        int read = this.mRandomAccess.read();
        if (read >= 0) {
            ++this.mPosition;
        }
        return read;
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        this.checkOpen();
        int read = this.mRandomAccess.read(pBytes, pOffset, pLength);
        if (read > 0) {
            this.mPosition += (long)read;
        }
        return read;
    }

    protected void flushBeforeImpl(long pPosition) {
    }

    protected void seekImpl(long pPosition) throws IOException {
        this.mRandomAccess.seek(pPosition);
    }
}

