/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.EmptyReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringArrayReader
extends StringReader {
    private StringReader mCurrent;
    private String[] mStrings;
    protected final Object mLock;
    private int mCurrentSting;
    private int mMarkedString;
    private int mMark;
    private int mNext;

    public StringArrayReader(String[] pStrings) {
        super("");
        if (pStrings == null) {
            throw new NullPointerException("strings == null");
        }
        this.lock = pStrings;
        this.mLock = pStrings;
        this.mStrings = (String[])pStrings.clone();
        this.nextReader();
    }

    protected final Reader nextReader() {
        this.mCurrent = this.mCurrentSting >= this.mStrings.length ? new EmptyReader() : new StringReader(this.mStrings[this.mCurrentSting++]);
        this.mNext = 0;
        return this.mCurrent;
    }

    protected final void ensureOpen() throws IOException {
        if (this.mStrings == null) {
            throw new IOException("Stream closed");
        }
    }

    public void close() {
        super.close();
        this.mStrings = null;
        this.mCurrent.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int pReadLimit) throws IOException {
        if (pReadLimit < 0) {
            throw new IllegalArgumentException("Read limit < 0");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureOpen();
            this.mMark = this.mNext;
            this.mMarkedString = this.mCurrentSting;
            this.mCurrent.mark(pReadLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.mCurrentSting != this.mMarkedString) {
                this.mCurrentSting = this.mMarkedString - 1;
                this.nextReader();
                this.mCurrent.skip(this.mMark);
            } else {
                this.mCurrent.reset();
            }
            this.mNext = this.mMark;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            int read = this.mCurrent.read();
            if (read < 0 && this.mCurrentSting < this.mStrings.length) {
                this.nextReader();
                return this.read();
            }
            ++this.mNext;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] pBuffer, int pOffset, int pLength) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            int read = this.mCurrent.read(pBuffer, pOffset, pLength);
            if (read < 0 && this.mCurrentSting < this.mStrings.length) {
                this.nextReader();
                return this.read(pBuffer, pOffset, pLength);
            }
            this.mNext += read;
            return read;
        }
    }

    public boolean ready() throws IOException {
        return this.mCurrent.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long pChars) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            long skipped = this.mCurrent.skip(pChars);
            if (skipped == 0L && this.mCurrentSting < this.mStrings.length) {
                this.nextReader();
                return this.skip(pChars);
            }
            this.mNext = (int)((long)this.mNext + skipped);
            return skipped;
        }
    }
}

