/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SubStream
extends FilterInputStream {
    private long mLeft;
    private int mMarkLimit;

    public SubStream(InputStream pStream, long pLength) {
        super(Validate.notNull(pStream, "stream"));
        this.mLeft = pLength;
    }

    public void close() throws IOException {
        while (this.mLeft > 0L) {
            this.skip(this.mLeft);
        }
    }

    public int available() throws IOException {
        return (int)Math.min((long)super.available(), this.mLeft);
    }

    public void mark(int pReadLimit) {
        super.mark(pReadLimit);
        this.mMarkLimit = pReadLimit;
    }

    public void reset() throws IOException {
        super.reset();
        this.mLeft += (long)this.mMarkLimit;
    }

    public int read() throws IOException {
        if (this.mLeft-- <= 0L) {
            return -1;
        }
        return super.read();
    }

    public final int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes.length);
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (this.mLeft <= 0L) {
            return -1;
        }
        int read = super.read(pBytes, pOffset, (int)this.findMaxLen(pLength));
        this.mLeft = read < 0 ? 0L : this.mLeft - (long)read;
        return read;
    }

    private long findMaxLen(long pLength) {
        if (this.mLeft < pLength) {
            return (int)Math.max(this.mLeft, 0L);
        }
        return pLength;
    }

    public long skip(long pLength) throws IOException {
        long skipped = super.skip(this.findMaxLen(pLength));
        this.mLeft -= skipped;
        return skipped;
    }
}

