/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileSystem;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.util.StringTokenIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

final class UnixFileSystem
extends FileSystem {
    UnixFileSystem() {
    }

    long getFreeSpace(File pPath) {
        try {
            return this.getNumber(pPath, 3);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    long getTotalSpace(File pPath) {
        try {
            return this.getNumber(pPath, 5);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNumber(File pPath, int pIndex) throws IOException {
        BufferedReader reader = UnixFileSystem.exec(new String[]{"df", "-k", pPath.getAbsolutePath()});
        String last = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                last = line;
            }
        }
        finally {
            FileUtil.close(reader);
        }
        if (last != null) {
            String blocks = null;
            StringTokenIterator tokens = new StringTokenIterator(last, " ", -1);
            for (int count = 0; count < pIndex && tokens.hasNext(); ++count) {
                blocks = tokens.nextToken();
            }
            if (blocks != null) {
                try {
                    return Long.parseLong(blocks) * 1024L;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    String getName() {
        return "Unix";
    }
}

