/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.NullOutputStream;
import com.twelvemonkeys.lang.DateUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class WriterOutputStream
extends OutputStream {
    protected Writer mWriter;
    protected final Decoder mDecoder;
    final ByteArrayOutputStream mBufferStream = new FastByteArrayOutputStream(1024);
    private volatile boolean mIsFlushing = false;
    private static final boolean NIO_AVAILABLE = WriterOutputStream.isNIOAvailable();

    private static boolean isNIOAvailable() {
        try {
            Class.forName("java.nio.charset.Charset");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public WriterOutputStream(Writer pWriter, String pCharset) {
        this.mWriter = pWriter;
        this.mDecoder = WriterOutputStream.getDecoder(pCharset);
    }

    public WriterOutputStream(Writer pWriter) {
        this(pWriter, null);
    }

    private static Decoder getDecoder(String pCharset) {
        if (NIO_AVAILABLE) {
            return new CharsetDecoder(pCharset);
        }
        return new StringDecoder(pCharset);
    }

    public void close() throws IOException {
        this.flush();
        this.mWriter.close();
        this.mWriter = null;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.mWriter.flush();
    }

    public final void write(byte[] pBytes) throws IOException {
        if (pBytes == null) {
            throw new NullPointerException("bytes == null");
        }
        this.write(pBytes, 0, pBytes.length);
    }

    public final void write(byte[] pBytes, int pOffset, int pLength) throws IOException {
        this.flushBuffer();
        this.mDecoder.decodeTo(this.mWriter, pBytes, pOffset, pLength);
    }

    public final void write(int pByte) {
        this.mBufferStream.write(pByte);
    }

    private void flushBuffer() throws IOException {
        if (!this.mIsFlushing && this.mBufferStream.size() > 0) {
            this.mIsFlushing = true;
            this.mBufferStream.writeTo(this);
            this.mBufferStream.reset();
            this.mIsFlushing = false;
        }
    }

    public static void main(String[] pArgs) throws IOException {
        int i;
        int iterations = 1000000;
        byte[] bytes = "\u00e5\u00f8\u00e6\u00c5\u00d8\u00c6 klashf lkash ljah lhaaklhghdfgu ksd".getBytes("UTF-8");
        PrintWriter sink = new PrintWriter(new NullOutputStream());
        Decoder d = new StringDecoder("UTF-8");
        for (i = 0; i < 10000; ++i) {
            d.decodeTo(sink, bytes, 0, bytes.length);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < iterations; ++i) {
            d.decodeTo(sink, bytes, 0, bytes.length);
        }
        long time = DateUtil.delta(start);
        System.out.println("StringDecoder");
        System.out.println("time: " + time);
        StringWriter writer = new StringWriter();
        d.decodeTo(writer, bytes, 0, bytes.length);
        String str = writer.toString();
        System.out.println("str: \"" + str + "\"");
        System.out.println("chars.length: " + str.length());
        System.out.println();
        if (NIO_AVAILABLE) {
            d = new CharsetDecoder("UTF-8");
            for (i = 0; i < 10000; ++i) {
                d.decodeTo(sink, bytes, 0, bytes.length);
            }
            start = System.currentTimeMillis();
            for (i = 0; i < iterations; ++i) {
                d.decodeTo(sink, bytes, 0, bytes.length);
            }
            time = DateUtil.delta(start);
            System.out.println("CharsetDecoder");
            System.out.println("time: " + time);
            writer = new StringWriter();
            d.decodeTo(writer, bytes, 0, bytes.length);
            str = writer.toString();
            System.out.println("str: \"" + str + "\"");
            System.out.println("chars.length: " + str.length());
            System.out.println();
        }
        WriterOutputStream os = new WriterOutputStream(new PrintWriter(System.out), "UTF-8");
        ((OutputStream)os).write(bytes);
        ((OutputStream)os).flush();
        System.out.println();
        for (byte b : bytes) {
            ((OutputStream)os).write(b & 0xFF);
        }
        ((OutputStream)os).flush();
    }

    private static final class StringDecoder
    implements Decoder {
        final String mCharset;

        StringDecoder(String pCharset) {
            this.mCharset = pCharset;
        }

        public void decodeTo(Writer pWriter, byte[] pBytes, int pOffset, int pLength) throws IOException {
            String str = this.mCharset == null ? new String(pBytes, pOffset, pLength) : new String(pBytes, pOffset, pLength, this.mCharset);
            pWriter.write(str);
        }
    }

    private static final class CharsetDecoder
    implements Decoder {
        final Charset mCharset;

        CharsetDecoder(String pCharset) {
            String charset = pCharset != null ? pCharset : System.getProperty("file.encoding", "ISO-8859-1");
            this.mCharset = Charset.forName(charset);
        }

        public void decodeTo(Writer pWriter, byte[] pBytes, int pOffset, int pLength) throws IOException {
            CharBuffer cb = this.mCharset.decode(ByteBuffer.wrap(pBytes, pOffset, pLength));
            pWriter.write(cb.array(), 0, cb.length());
        }
    }

    private static interface Decoder {
        public void decodeTo(Writer var1, byte[] var2, int var3, int var4) throws IOException;
    }
}

