/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public final class PackBitsEncoder
implements Encoder {
    private final byte[] mBuffer = new byte[128];

    public void encode(OutputStream pStream, byte[] pBuffer, int pOffset, int pLength) throws IOException {
        int offset = pOffset;
        int max = pOffset + pLength - 1;
        int maxMinus1 = max - 1;
        while (offset <= max) {
            int run;
            byte replicate = pBuffer[offset];
            for (run = 1; run < 127 && offset < max && pBuffer[offset] == pBuffer[offset + 1]; ++offset, ++run) {
            }
            if (run > 1) {
                ++offset;
                pStream.write(-(run - 1));
                pStream.write(replicate);
            }
            run = 0;
            while (run < 128 && (offset < max && pBuffer[offset] != pBuffer[offset + 1] || offset < maxMinus1 && pBuffer[offset] != pBuffer[offset + 2])) {
                this.mBuffer[run++] = pBuffer[offset++];
            }
            if (offset == max && run > 0 && run < 128) {
                this.mBuffer[run++] = pBuffer[offset++];
            }
            if (run > 0) {
                pStream.write(run - 1);
                pStream.write(this.mBuffer, 0, run);
            }
            if (offset != max || run > 0 && run < 128) continue;
            pStream.write(0);
            pStream.write(pBuffer[offset++]);
        }
    }
}

