/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.ReflectUtil;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanUtil {
    private BeanUtil() {
    }

    public static Object getPropertyValue(Object pObject, String pProperty) {
        int begIdx;
        if (pObject == null || pProperty == null || pProperty.length() < 1) {
            return null;
        }
        Class<?> objClass = pObject.getClass();
        Object result = pObject;
        int endIdx = begIdx = 0;
        while (begIdx < pProperty.length() && begIdx >= 0) {
            Method method;
            String subProp;
            if ((endIdx = pProperty.indexOf(".", endIdx + 1)) > 0) {
                subProp = pProperty.substring(begIdx, endIdx);
                begIdx = endIdx + 1;
            } else {
                subProp = pProperty.substring(begIdx);
                begIdx = -1;
            }
            Object[] param = null;
            Class[] paramClass = new Class[]{};
            int begBracket = subProp.indexOf("[");
            if (begBracket > 0) {
                if (!subProp.endsWith("]")) {
                    return null;
                }
                String between = subProp.substring(begBracket + 1, subProp.length() - 1);
                subProp = subProp.substring(0, begBracket);
                param = new Object[1];
                paramClass = new Class[1];
                if (StringUtil.isNumber(between)) {
                    try {
                        param[0] = Integer.valueOf(between);
                        paramClass[0] = Integer.TYPE;
                    }
                    catch (NumberFormatException e) {}
                } else {
                    param[0] = between.toLowerCase();
                    paramClass[0] = String.class;
                }
            }
            String methodName = "get" + StringUtil.capitalize(subProp);
            try {
                method = objClass.getMethod(methodName, paramClass);
            }
            catch (NoSuchMethodException e) {
                System.err.print("No method named \"" + methodName + "()\"");
                if (paramClass != null && paramClass.length > 0) {
                    System.err.print(" with the parameter " + paramClass[0].getName());
                }
                System.err.println(" in class " + objClass.getName() + "!");
                return null;
            }
            if (method == null) {
                return null;
            }
            try {
                result = method.invoke(result, param);
            }
            catch (InvocationTargetException e) {
                System.err.println("property=" + pProperty + " & result=" + result + " & param=" + Arrays.toString(param));
                e.getTargetException().printStackTrace();
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (NullPointerException e) {
                System.err.println(objClass.getName() + "." + method.getName() + "(" + (paramClass != null && paramClass.length > 0 ? paramClass[0].getName() : "") + ")");
                e.printStackTrace();
                return null;
            }
            if (result != null) {
                objClass = result.getClass();
                continue;
            }
            return null;
        }
        return result;
    }

    public static void setPropertyValue(Object pObject, String pProperty, Object pValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class paramType = pValue != null ? pValue.getClass() : Object.class;
        Object obj = pObject;
        String property = pProperty;
        int dotIdx = property.indexOf(46);
        if (dotIdx >= 0) {
            obj = BeanUtil.getPropertyValue(obj, property.substring(0, dotIdx));
            property = property.substring(dotIdx + 1);
        }
        Object[] params = new Object[]{pValue};
        Method method = BeanUtil.getMethodMayModifyParams(obj, "set" + StringUtil.capitalize(property), new Class[]{paramType}, params);
        method.invoke(obj, params);
    }

    private static Method getMethodMayModifyParams(Object pObject, String pName, Class[] pParams, Object[] pValues) throws NoSuchMethodException {
        Method method;
        block13: {
            method = null;
            Class paramType = pParams[0];
            try {
                method = pObject.getClass().getMethod(pName, pParams);
            }
            catch (NoSuchMethodException e) {
                if (ReflectUtil.isPrimitiveWrapper(paramType)) {
                    pParams[0] = ReflectUtil.unwrapType(paramType);
                }
                try {
                    method = pObject.getClass().getMethod(pName, pParams);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (method == null) {
                    while ((paramType = paramType.getSuperclass()) != null) {
                        pParams[0] = paramType;
                        try {
                            method = pObject.getClass().getMethod(pName, pParams);
                            break;
                        }
                        catch (Throwable t) {
                        }
                    }
                }
                if (method == null) {
                    Method[] methods;
                    for (Method candidate : methods = pObject.getClass().getMethods()) {
                        if (!Modifier.isPublic(candidate.getModifiers()) || !candidate.getName().equals(pName) || candidate.getReturnType() != Void.TYPE || candidate.getParameterTypes().length != 1) continue;
                        Class<?> type = candidate.getParameterTypes()[0];
                        try {
                            pValues[0] = BeanUtil.convertValueToType(pValues[0], type);
                        }
                        catch (Throwable t) {
                            continue;
                        }
                        method = candidate;
                        break;
                    }
                }
                if (method != null) break block13;
                throw e;
            }
        }
        return method;
    }

    private static Object convertValueToType(Object pValue, Class pType) throws ConversionException {
        if (pType.isPrimitive()) {
            if (pType == Boolean.TYPE && pValue instanceof Boolean) {
                return pValue;
            }
            if (pType == Byte.TYPE && pValue instanceof Byte) {
                return pValue;
            }
            if (pType == Character.TYPE && pValue instanceof Character) {
                return pValue;
            }
            if (pType == Double.TYPE && pValue instanceof Double) {
                return pValue;
            }
            if (pType == Float.TYPE && pValue instanceof Float) {
                return pValue;
            }
            if (pType == Integer.TYPE && pValue instanceof Integer) {
                return pValue;
            }
            if (pType == Long.TYPE && pValue instanceof Long) {
                return pValue;
            }
            if (pType == Short.TYPE && pValue instanceof Short) {
                return pValue;
            }
        }
        if (pValue instanceof String) {
            Converter converter = Converter.getInstance();
            return converter.toObject((String)pValue, pType);
        }
        if (pType == String.class) {
            Converter converter = Converter.getInstance();
            return converter.toString(pValue);
        }
        throw new ConversionException("Cannot convert " + pValue.getClass().getName() + " to " + pType.getName());
    }

    public static Object createInstance(Class pClass, Object pParam) throws InvocationTargetException {
        return BeanUtil.createInstance(pClass, new Object[]{pParam});
    }

    public static Object createInstance(Class pClass, Object ... pParams) throws InvocationTargetException {
        Object value;
        try {
            Class[] paramTypes = null;
            if (pParams != null && pParams.length > 0) {
                paramTypes = new Class[pParams.length];
                for (int i = 0; i < pParams.length; ++i) {
                    paramTypes[i] = pParams[i].getClass();
                }
            }
            Constructor constructor = pClass.getConstructor(paramTypes);
            value = constructor.newInstance(pParams);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (IllegalArgumentException iarge) {
            return null;
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (ExceptionInInitializerError err) {
            return null;
        }
        return value;
    }

    public static Object invokeStaticMethod(Class pClass, String pMethod, Object pParam) throws InvocationTargetException {
        return BeanUtil.invokeStaticMethod(pClass, pMethod, new Object[]{pParam});
    }

    public static Object invokeStaticMethod(Class pClass, String pMethod, Object[] pParams) throws InvocationTargetException {
        Object value = null;
        try {
            Class[] paramTypes = new Class[pParams.length];
            for (int i = 0; i < pParams.length; ++i) {
                paramTypes[i] = pParams[i].getClass();
            }
            Method method = pClass.getMethod(pMethod, paramTypes);
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                value = method.invoke(null, pParams);
            }
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (IllegalArgumentException iarge) {
            return null;
        }
        return value;
    }

    public static void configure(Object pBean, Map<String, ?> pMapping) throws InvocationTargetException {
        BeanUtil.configure(pBean, pMapping, false);
    }

    public static void configure(Object pBean, Map<String, ?> pMapping, boolean pLispToCamel) throws InvocationTargetException {
        for (Map.Entry<String, ?> entry : pMapping.entrySet()) {
            try {
                String property = StringUtil.valueOf(entry.getKey());
                try {
                    BeanUtil.setPropertyValue(pBean, property, entry.getValue());
                }
                catch (NoSuchMethodException ignore) {
                    if (!pLispToCamel || property.indexOf(45) <= 0) continue;
                    BeanUtil.setPropertyValue(pBean, StringUtil.lispToCamel(property, false), entry.getValue());
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {}
        }
    }
}

