/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validate {
    private static final String UNSPECIFIED_PARAM_NAME = "method parameter";

    private Validate() {
    }

    public static <T> T notNull(T pParameter) {
        return Validate.notNull(pParameter, null);
    }

    public static <T> T notNull(T pParameter, String pParamName) {
        if (pParameter == null) {
            throw new IllegalArgumentException(String.format("%s may not be null", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T extends CharSequence> T notEmpty(T pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T extends CharSequence> T notEmpty(T pParameter, String pParamName) {
        if (pParameter == null || pParameter.length() == 0) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T> T[] notEmpty(T[] pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T> T[] notEmpty(T[] pParameter, String pParamName) {
        if (pParameter == null || pParameter.length == 0) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T> Collection<T> notEmpty(Collection<T> pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T> Collection<T> notEmpty(Collection<T> pParameter, String pParamName) {
        if (pParameter == null || pParameter.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> pParameter, String pParamName) {
        if (pParameter == null || pParameter.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T> T[] noNullElements(T[] pParameter) {
        return Validate.noNullElements(pParameter, null);
    }

    public static <T> T[] noNullElements(T[] pParameter, String pParamName) {
        Validate.noNullElements(Arrays.asList(pParameter), pParamName);
        return pParameter;
    }

    public static <T> Collection<T> noNullElements(Collection<T> pParameter) {
        return Validate.noNullElements(pParameter, null);
    }

    public static <T> Collection<T> noNullElements(Collection<T> pParameter, String pParamName) {
        for (T element : pParameter) {
            if (element != null) continue;
            throw new IllegalArgumentException(String.format("%s may not contain null elements", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <K, V> Map<K, V> noNullElements(Map<K, V> pParameter) {
        return Validate.noNullElements(pParameter, null);
    }

    public static <K, V> Map<K, V> noNullElements(Map<K, V> pParameter, String pParamName) {
        for (V element : pParameter.values()) {
            if (element != null) continue;
            throw new IllegalArgumentException(String.format("%s may not contain null elements", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }
}

