/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDecoratedMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    protected Map<K, Map.Entry<K, V>> mEntries;
    protected volatile transient int mModCount;
    private volatile transient Set<Map.Entry<K, V>> mEntrySet = null;
    private volatile transient Set<K> mKeySet = null;
    private volatile transient Collection<V> mValues = null;

    public AbstractDecoratedMap() {
        this(new HashMap(), null);
    }

    public AbstractDecoratedMap(Map<? extends K, ? extends V> pContents) {
        this(new HashMap(), pContents);
    }

    public AbstractDecoratedMap(Map<K, Map.Entry<K, V>> pBacking, Map<? extends K, ? extends V> pContents) {
        if (pBacking == null) {
            throw new IllegalArgumentException("backing == null");
        }
        Map.Entry[] entries = null;
        if (pBacking == pContents) {
            Set<Map.Entry<K, V>> es = pContents.entrySet();
            entries = new Map.Entry[es.size()];
            entries = es.toArray(entries);
            pContents = null;
            pBacking.clear();
        } else if (!pBacking.isEmpty()) {
            throw new IllegalArgumentException("backing must be empty");
        }
        this.mEntries = pBacking;
        this.init();
        if (pContents != null) {
            this.putAll(pContents);
        } else if (entries != null) {
            for (Map.Entry entry : entries) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void init() {
    }

    @Override
    public int size() {
        return this.mEntries.size();
    }

    @Override
    public void clear() {
        this.mEntries.clear();
        ++this.mModCount;
        this.init();
    }

    @Override
    public boolean isEmpty() {
        return this.mEntries.isEmpty();
    }

    @Override
    public boolean containsKey(Object pKey) {
        return this.mEntries.containsKey(pKey);
    }

    @Override
    public boolean containsValue(Object pValue) {
        for (V value : this.values()) {
            if (value != pValue && (value == null || !value.equals(pValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        Values values = this.mValues;
        return values != null ? values : (this.mValues = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.mEntrySet;
        return es != null ? es : (this.mEntrySet = new EntrySet());
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.mKeySet;
        return ks != null ? ks : (this.mKeySet = new KeySet());
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        AbstractDecoratedMap map = (AbstractDecoratedMap)super.clone();
        map.mValues = null;
        map.mEntrySet = null;
        map.mKeySet = null;
        return map;
    }

    protected abstract Iterator<K> newKeyIterator();

    protected abstract Iterator<V> newValueIterator();

    protected abstract Iterator<Map.Entry<K, V>> newEntryIterator();

    @Override
    public abstract V get(Object var1);

    @Override
    public abstract V remove(Object var1);

    @Override
    public abstract V put(K var1, V var2);

    Map.Entry<K, V> createEntry(K pKey, V pValue) {
        return new BasicEntry<K, V>(pKey, pValue);
    }

    Map.Entry<K, V> getEntry(K pKey) {
        return this.mEntries.get(pKey);
    }

    protected Map.Entry<K, V> removeEntry(Map.Entry<K, V> pEntry) {
        if (pEntry == null) {
            return null;
        }
        Map.Entry<K, V> candidate = this.getEntry(pEntry.getKey());
        if (candidate == pEntry || candidate != null && ((Object)candidate).equals(pEntry)) {
            this.remove(pEntry.getKey());
            return pEntry;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BasicEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        K mKey;
        V mValue;

        BasicEntry(K pKey, V pValue) {
            this.mKey = pKey;
            this.mValue = pValue;
        }

        protected void recordAccess(Map<K, V> pMap) {
        }

        protected void recordRemoval(Map<K, V> pMap) {
        }

        @Override
        public V getValue() {
            return this.mValue;
        }

        @Override
        public V setValue(V pValue) {
            V oldValue = this.mValue;
            this.mValue = pValue;
            return oldValue;
        }

        @Override
        public K getKey() {
            return this.mKey;
        }

        @Override
        public boolean equals(Object pOther) {
            Object v2;
            V v1;
            if (!(pOther instanceof Map.Entry)) {
                return false;
            }
            K k1 = this.mKey;
            Map.Entry entry = (Map.Entry)pOther;
            Object k2 = entry.getKey();
            return (k1 == k2 || k1 != null && k1.equals(k2)) && ((v1 = this.mValue) == (v2 = entry.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.mKey == null ? 0 : this.mKey.hashCode()) ^ (this.mValue == null ? 0 : this.mValue.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeySet
    extends AbstractSet<K> {
        protected KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return AbstractDecoratedMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return AbstractDecoratedMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractDecoratedMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDecoratedMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDecoratedMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractDecoratedMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Map.Entry candidate = AbstractDecoratedMap.this.mEntries.get(e.getKey());
            return candidate != null && ((Object)candidate).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return AbstractDecoratedMap.this.removeEntry((Map.Entry)o) != null;
        }

        @Override
        public int size() {
            return AbstractDecoratedMap.this.size();
        }

        @Override
        public void clear() {
            AbstractDecoratedMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Values
    extends AbstractCollection<V> {
        protected Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return AbstractDecoratedMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return AbstractDecoratedMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractDecoratedMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractDecoratedMap.this.clear();
        }
    }
}

