/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanMap
extends AbstractMap<String, Object>
implements Serializable,
Cloneable {
    private final Object mBean;
    private transient Set<PropertyDescriptor> mDescriptors;

    public BeanMap(Object pBean) throws IntrospectionException {
        if (pBean == null) {
            throw new IllegalArgumentException("bean == null");
        }
        this.mBean = pBean;
        this.mDescriptors = BeanMap.initDescriptors(pBean);
    }

    private static Set<PropertyDescriptor> initDescriptors(Object pBean) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        HashSet<PropertyDescriptor> descriptors = new HashSet<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : propertyDescriptors = Introspector.getBeanInfo(pBean.getClass()).getPropertyDescriptors()) {
            if ("class".equals(descriptor.getName()) && descriptor.getPropertyType() == Class.class || descriptor instanceof IndexedPropertyDescriptor) continue;
            descriptors.add(descriptor);
        }
        return Collections.unmodifiableSet(descriptors);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new BeanSet();
    }

    @Override
    public Object get(Object pKey) {
        return super.get(pKey);
    }

    @Override
    public Object put(String pKey, Object pValue) {
        this.checkKey(pKey);
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (!entry.getKey().equals(pKey)) continue;
            return entry.setValue(pValue);
        }
        return null;
    }

    @Override
    public Object remove(Object pKey) {
        return super.remove(this.checkKey(pKey));
    }

    @Override
    public int size() {
        return this.mDescriptors.size();
    }

    private String checkKey(Object pKey) {
        if (pKey == null) {
            throw new IllegalArgumentException("key == null");
        }
        String name = (String)pKey;
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Bad key: " + pKey);
        }
        return name;
    }

    private Object readResolve() throws IntrospectionException {
        this.mDescriptors = BeanMap.initDescriptors(this.mBean);
        return this;
    }

    private static Object unwrap(Wrapped wrapped) {
        try {
            return wrapped.run();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private static interface Wrapped {
        public Object run() throws IllegalAccessException, InvocationTargetException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanEntry
    implements Map.Entry<String, Object> {
        private final PropertyDescriptor mDescriptor;

        public BeanEntry(PropertyDescriptor pDescriptor) {
            this.mDescriptor = pDescriptor;
        }

        @Override
        public String getKey() {
            return this.mDescriptor.getName();
        }

        @Override
        public Object getValue() {
            return BeanMap.unwrap(new Wrapped(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method method = BeanEntry.this.mDescriptor.getReadMethod();
                    if (method == null) {
                        throw new UnsupportedOperationException("No getter: " + BeanEntry.this.mDescriptor.getName());
                    }
                    return method.invoke(BeanMap.this.mBean, new Object[0]);
                }
            });
        }

        @Override
        public Object setValue(final Object pValue) {
            return BeanMap.unwrap(new Wrapped(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method method = BeanEntry.this.mDescriptor.getWriteMethod();
                    if (method == null) {
                        throw new UnsupportedOperationException("No write method for property: " + BeanEntry.this.mDescriptor.getName());
                    }
                    Object old = BeanEntry.this.getValue();
                    method.invoke(BeanMap.this.mBean, pValue);
                    return old;
                }
            });
        }

        @Override
        public boolean equals(Object pOther) {
            Object v2;
            Object v1;
            Object k2;
            if (!(pOther instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)pOther;
            String k1 = this.getKey();
            return (k1 == (k2 = entry.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = entry.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<PropertyDescriptor> mIterator;

        public BeanIterator(Iterator<PropertyDescriptor> pIterator) {
            this.mIterator = pIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public BeanEntry next() {
            return new BeanEntry(this.mIterator.next());
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private BeanSet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new BeanIterator(BeanMap.this.mDescriptors.iterator());
        }

        @Override
        public int size() {
            return BeanMap.this.mDescriptors.size();
        }
    }
}

