/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DuplicateHandler<T> {
    public static final DuplicateHandler<?> USE_FIRST_VALUE = new DuplicateHandler(){

        public Object resolve(Object pOld, Object pNew) {
            return pOld;
        }
    };
    public static final DuplicateHandler<?> USE_LAST_VALUE = new DuplicateHandler(){

        public Object resolve(Object pOld, Object pNew) {
            return pNew;
        }
    };
    public static final DuplicateHandler<?> DUPLICATES_AS_ARRAY = new DuplicateHandler(){

        public Object resolve(Object pOld, Object pNew) {
            Object[] result;
            if (pOld instanceof Object[]) {
                Object[] old = (Object[])pOld;
                result = new Object[old.length + 1];
                System.arraycopy(old, 0, result, 0, old.length);
                result[old.length] = pNew;
            } else {
                result = new Object[]{pOld, pNew};
            }
            return result;
        }
    };
    public static final DuplicateHandler<String> DUPLICATES_AS_CSV = new DuplicateHandler<String>(){

        @Override
        public String resolve(String pOld, String pNew) {
            StringBuilder result = new StringBuilder(String.valueOf(pOld));
            result.append(',');
            result.append(pNew);
            return result.toString();
        }
    };

    public T resolve(T var1, T var2);
}

