/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.FileResource;
import com.twelvemonkeys.util.Resource;
import com.twelvemonkeys.util.ResourceChangeListener;
import com.twelvemonkeys.util.URLResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ResourceMonitor {
    private static final ResourceMonitor INSTANCE = new ResourceMonitor(){};
    private Timer mTimer = new Timer(true);
    private Map mTimerEntries = new HashMap();

    public static ResourceMonitor getInstance() {
        return INSTANCE;
    }

    protected ResourceMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceChangeListener(ResourceChangeListener pListener, Object pResourceId, long pPeriod) throws IOException {
        ResourceMonitorTask task = new ResourceMonitorTask(pListener, pResourceId);
        Object resourceId = this.getResourceId(pResourceId, pListener);
        Map map = this.mTimerEntries;
        synchronized (map) {
            this.removeListenerInternal(resourceId);
            this.mTimerEntries.put(resourceId, task);
        }
        this.mTimer.schedule((TimerTask)task, pPeriod, pPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceChangeListener(ResourceChangeListener pListener, Object pResourceId) {
        Map map = this.mTimerEntries;
        synchronized (map) {
            this.removeListenerInternal(this.getResourceId(pResourceId, pListener));
        }
    }

    private void removeListenerInternal(Object pResourceId) {
        ResourceMonitorTask task = (ResourceMonitorTask)this.mTimerEntries.remove(pResourceId);
        if (task != null) {
            task.cancel();
        }
    }

    private Object getResourceId(Object pResourceName, ResourceChangeListener pListener) {
        return pResourceName.toString() + System.identityHashCode(pListener);
    }

    private void fireResourceChangeEvent(ResourceChangeListener pListener, Resource pResource) {
        pListener.resourceChanged(pResource);
    }

    private class ResourceMonitorTask
    extends TimerTask {
        ResourceChangeListener mListener;
        Resource mMonitoredResource;
        long mLastModified;

        public ResourceMonitorTask(ResourceChangeListener pListener, Object pResourceId) throws IOException {
            this.mListener = pListener;
            this.mLastModified = 0L;
            String resourceId = null;
            File file = null;
            URL url = null;
            if (pResourceId instanceof File) {
                file = (File)pResourceId;
                resourceId = file.getAbsolutePath();
            } else if (pResourceId instanceof URL) {
                url = (URL)pResourceId;
                if ("file".equals(url.getProtocol())) {
                    file = new File(url.getFile());
                }
                resourceId = url.toExternalForm();
            } else if (pResourceId instanceof String) {
                resourceId = (String)pResourceId;
                file = new File(resourceId);
            }
            if (file != null && file.exists()) {
                this.mMonitoredResource = new FileResource(pResourceId, file);
            } else {
                if (url == null) {
                    url = pListener.getClass().getClassLoader().getResource(resourceId);
                }
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(resourceId);
                }
                if (url != null && "file".equals(url.getProtocol()) && (file = new File(url.getFile())).exists()) {
                    this.mMonitoredResource = new FileResource(pResourceId, file);
                } else if (url != null) {
                    this.mMonitoredResource = new URLResource(pResourceId, url);
                } else {
                    throw new FileNotFoundException(resourceId);
                }
            }
            this.mLastModified = this.mMonitoredResource.lastModified();
        }

        public void run() {
            long lastModified = this.mMonitoredResource.lastModified();
            if (lastModified != this.mLastModified) {
                this.mLastModified = lastModified;
                ResourceMonitor.this.fireResourceChangeEvent(this.mListener, this.mMonitoredResource);
            }
        }
    }
}

