/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.AbstractTokenIterator;
import java.util.NoSuchElementException;

public class StringTokenIterator
extends AbstractTokenIterator {
    private final String mString;
    private final char[] mDelimiters;
    private int mPosition;
    private final int mMaxPosition;
    private String mNext;
    private String mNextDelimiter;
    private final boolean mIncludeDelimiters;
    private final boolean mIncludeEmpty;
    private final boolean mReverse;
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    private final char mMaxDelimiter;

    public StringTokenIterator(String pString) {
        this(pString, " \t\n\r\f".toCharArray(), 1, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), 1, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, int pDirection) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), pDirection, false, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, boolean pIncludeDelimiters) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), 1, pIncludeDelimiters, false);
    }

    public StringTokenIterator(String pString, String pDelimiters, int pDirection, boolean pIncludeDelimiters, boolean pIncludeEmpty) {
        this(pString, StringTokenIterator.toCharArray(pDelimiters), pDirection, pIncludeDelimiters, pIncludeEmpty);
    }

    private StringTokenIterator(String pString, char[] pDelimiters, int pDirection, boolean pIncludeDelimiters, boolean pIncludeEmpty) {
        if (pString == null) {
            throw new IllegalArgumentException("string == null");
        }
        this.mString = pString;
        this.mMaxPosition = pString.length();
        this.mDelimiters = pDelimiters;
        this.mIncludeDelimiters = pIncludeDelimiters;
        this.mReverse = pDirection == -1;
        this.mIncludeEmpty = pIncludeEmpty;
        this.mMaxDelimiter = StringTokenIterator.initMaxDelimiter(pDelimiters);
        this.reset();
    }

    private static char[] toCharArray(String pDelimiters) {
        if (pDelimiters == null) {
            throw new IllegalArgumentException("delimiters == null");
        }
        return pDelimiters.toCharArray();
    }

    private static char initMaxDelimiter(char[] pDelimiters) {
        if (pDelimiters == null) {
            return '\u0000';
        }
        char max = '\u0000';
        for (char c : pDelimiters) {
            if (max >= c) continue;
            max = c;
        }
        return max;
    }

    public void reset() {
        this.mPosition = 0;
        this.mNext = null;
        this.mNextDelimiter = null;
    }

    public boolean hasNext() {
        return this.mNext != null || this.fetchNext() != null;
    }

    private String fetchNext() {
        if (this.mNextDelimiter != null) {
            this.mNext = this.mNextDelimiter;
            this.mNextDelimiter = null;
            return this.mNext;
        }
        if (this.mPosition >= this.mMaxPosition) {
            return null;
        }
        return this.mReverse ? this.fetchReverse() : this.fetchForward();
    }

    private String fetchReverse() {
        int prevPos = this.scanForPrev();
        this.mNext = this.mString.substring(prevPos + 1, this.mMaxPosition - this.mPosition);
        if (this.mIncludeDelimiters && prevPos >= 0 && prevPos < this.mMaxPosition) {
            this.mNextDelimiter = this.mString.substring(prevPos, prevPos + 1);
        }
        this.mPosition = this.mMaxPosition - prevPos;
        if (this.mNext.length() == 0 && !this.mIncludeEmpty) {
            return this.fetchNext();
        }
        return this.mNext;
    }

    private String fetchForward() {
        int nextPos = this.scanForNext();
        this.mNext = this.mString.substring(this.mPosition, nextPos);
        if (this.mIncludeDelimiters && nextPos >= 0 && nextPos < this.mMaxPosition) {
            this.mNextDelimiter = this.mString.substring(nextPos, nextPos + 1);
        }
        this.mPosition = ++nextPos;
        if (this.mNext.length() == 0 && !this.mIncludeEmpty) {
            return this.fetchNext();
        }
        return this.mNext;
    }

    private int scanForNext() {
        int position;
        for (position = this.mPosition; position < this.mMaxPosition; ++position) {
            char c = this.mString.charAt(position);
            if (c > this.mMaxDelimiter) continue;
            for (char delimiter : this.mDelimiters) {
                if (c != delimiter) continue;
                return position;
            }
        }
        return position;
    }

    private int scanForPrev() {
        int position;
        for (position = this.mMaxPosition - 1 - this.mPosition; position >= 0; --position) {
            char c = this.mString.charAt(position);
            if (c > this.mMaxDelimiter) continue;
            for (char delimiter : this.mDelimiters) {
                if (c != delimiter) continue;
                return position;
            }
        }
        return position;
    }

    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String next = this.mNext;
        this.mNext = this.fetchNext();
        return next;
    }
}

