/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.BeanUtil;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.LRUHashMap;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.PropertyConverter;
import com.twelvemonkeys.util.convert.TypeMismathException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class NumberConverter
implements PropertyConverter {
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final NumberFormat sDefaultFormat = new DecimalFormat("#0.#", SYMBOLS);
    private static final Map<String, Format> sFormats = new LRUHashMap<String, Format>(50);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toObject(String pString, Class pType, String pFormat) throws ConversionException {
        if (StringUtil.isEmpty(pString)) {
            return null;
        }
        try {
            Number num;
            if (pType.equals(BigInteger.class)) {
                return new BigInteger(pString);
            }
            if (pType.equals(BigDecimal.class)) {
                return new BigDecimal(pString);
            }
            NumberFormat format = pFormat == null ? sDefaultFormat : this.getNumberFormat(pFormat);
            NumberFormat numberFormat = format;
            synchronized (numberFormat) {
                num = format.parse(pString);
            }
            if (pType == Integer.TYPE || pType == Integer.class) {
                return num.intValue();
            }
            if (pType == Long.TYPE || pType == Long.class) {
                return num.longValue();
            }
            if (pType == Double.TYPE || pType == Double.class) {
                return num.doubleValue();
            }
            if (pType == Float.TYPE || pType == Float.class) {
                return Float.valueOf(num.floatValue());
            }
            if (pType == Byte.TYPE || pType == Byte.class) {
                return num.byteValue();
            }
            if (pType == Short.TYPE || pType == Short.class) {
                return num.shortValue();
            }
            return num;
        }
        catch (ParseException pe) {
            throw new ConversionException(pe);
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object pObject, String pFormat) throws ConversionException {
        if (pObject == null) {
            return null;
        }
        if (!(pObject instanceof Number)) {
            throw new TypeMismathException(pObject.getClass());
        }
        try {
            NumberFormat format;
            if (StringUtil.isEmpty(pFormat)) {
                return sDefaultFormat.format(pObject);
            }
            NumberFormat numberFormat = format = this.getNumberFormat(pFormat);
            synchronized (numberFormat) {
                return format.format(pObject);
            }
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    private NumberFormat getNumberFormat(String pFormat) {
        return (NumberFormat)this.getFormat(DecimalFormat.class, pFormat, SYMBOLS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Format getFormat(Class pFormatterClass, Object ... pFormat) {
        Map<String, Format> map = sFormats;
        synchronized (map) {
            String key = pFormatterClass.getName() + ":" + Arrays.toString(pFormat);
            Format format = sFormats.get(key);
            if (format == null) {
                try {
                    format = (Format)BeanUtil.createInstance(pFormatterClass, pFormat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                sFormats.put(key, format);
            }
            return format;
        }
    }
}

