/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public class Borders {
    private static Border menuBorder;
    private static Border popupBorder;
    private static Border textFieldBorder;
    private static Border tableHeaderBorder;
    private static Border progressBarBorder;
    public static final Border MAIN_TABLE_BORDER;
    public static final Border MAIN_TABLE_BORDER_WITH_FOOTER;

    static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        }
        return menuBorder;
    }

    static Border getPopupBorder() {
        if (popupBorder == null) {
            popupBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        }
        return popupBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = new BorderUIResource(new ProgressBarBorder());
        }
        return progressBarBorder;
    }

    static {
        MAIN_TABLE_BORDER = BorderFactory.createCompoundBorder(LafUtils.createEmptyBorder(0, 20, 15, 20), BorderFactory.createLineBorder(PureLookAndFeel.getCurrentTheme().getPrimaryControl(), LafUtils.scalingInt(1)));
        MAIN_TABLE_BORDER_WITH_FOOTER = BorderFactory.createCompoundBorder(LafUtils.createEmptyBorder(0, 20, 0, 20), BorderFactory.createLineBorder(PureLookAndFeel.getCurrentTheme().getPrimaryControl(), LafUtils.scalingInt(1)));
    }

    private static final class ProgressBarBorder
    extends AbstractBorder {
        private static final Insets INSETS = LafUtils.createInsets(2, 2, 2, 2);

        private ProgressBarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean enabled = c.isEnabled();
            g.setColor(enabled ? PureLookAndFeel.getCurrentTheme().getPrimaryControl() : PureLookAndFeel.getCurrentTheme().getInactiveControlTextColor());
            LafUtils.drawRect(g, x, y, w - LafUtils.scalingInt(1), h - LafUtils.scalingInt(1));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }

    private static final class TextFieldBorder
    extends AbstractBorder {
        private TextFieldBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean showFocusBorder;
            boolean editable = c instanceof JTextComponent && c.isEnabled() && ((JTextComponent)c).isEditable();
            boolean enabled = editable || c.isEnabled();
            boolean bl = showFocusBorder = editable && c.isFocusOwner();
            g.setColor(enabled ? (showFocusBorder ? PureLookAndFeel.getCurrentTheme().getFocusColor() : PureLookAndFeel.getCurrentTheme().getPrimaryControl()) : PureLookAndFeel.getCurrentTheme().getPrimaryControl());
            LafUtils.drawRect(g, x, y, w - LafUtils.scalingInt(1), h - LafUtils.scalingInt(1));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return LafUtils.createInsets(3, 1, 2, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            Insets insets = LafUtils.createInsets(3, 1, 2, 1);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static final class MenuBorder
    extends LineBorder
    implements UIResource {
        public MenuBorder() {
            super(PureLookAndFeel.getCurrentTheme().getPrimaryControl(), LafUtils.scalingInt(1));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() || model.isSelected()) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    private static final class TableHeaderBorder
    implements Border {
        private TableHeaderBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(PureLookAndFeel.getCurrentTheme().getMenuColorScheme().getBackground());
            g.drawLine(x + width - LafUtils.scalingInt(1), y, x + width - LafUtils.scalingInt(1), y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return LafUtils.createInsets(0, 10, 0, 10);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = LafUtils.createInsets(6, 1, 6, 1);

        private PopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
            int onePixel = LafUtils.scalingInt(1);
            int twoPixel = LafUtils.scalingInt(2);
            int threePixel = LafUtils.scalingInt(3);
            int fourPixel = LafUtils.scalingInt(4);
            int fivePixel = LafUtils.scalingInt(5);
            int sixPixel = LafUtils.scalingInt(6);
            int sevenPixel = LafUtils.scalingInt(7);
            int ninePixel = LafUtils.scalingInt(8);
            int elevenPixel = LafUtils.scalingInt(11);
            g.drawRect(0, 0, w - onePixel, h - onePixel);
            g.setColor(PureLookAndFeel.getCurrentTheme().getMenuColorScheme().getBackground());
            g.drawRect(onePixel, onePixel, w - threePixel, h - threePixel);
            g.drawRect(twoPixel, twoPixel, w - fivePixel, h - fivePixel);
            g.drawRect(threePixel, threePixel, w - sevenPixel, h - sevenPixel);
            g.drawRect(fourPixel, fourPixel, w - ninePixel, h - ninePixel);
            g.drawRect(sixPixel, fivePixel, w - elevenPixel, h - elevenPixel);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }
}

