/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureComponentMouseAdapter;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import com.agilemind.utils.StyleConstants;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class PureAbstractButtonUI
extends BasicButtonUI {
    protected PureComponentMouseAdapter adapter;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.adapter = new PureComponentMouseAdapter(b);
        this.adapter.installAdapter();
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        this.adapter.uninstallAdapter();
        super.uninstallDefaults(b);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!this.adapter.pressed && b.getModel().isEnabled()) {
            this.paintFocus(g, b);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.getPressedPaint(b));
            g2d.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractButton button = (AbstractButton)c;
        if (button.isOpaque()) {
            Paint gradient = this.adapter.rollover ? this.getButtonGradientHover(c) : this.getButtonGradientNormal(c);
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, button.getWidth(), button.getHeight());
            g2d.setPaint(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
            this.drawButtonRect(g2d, button);
        }
        this.paint(g, c);
        if (button.getModel().isEnabled() && c.getRootPane().getDefaultButton() == button) {
            this.paintFocus(g, button);
        }
    }

    protected Paint getButtonGradientHover(JComponent b) {
        return StyleConstants.createButtonGradientHover(0.0f, b.getHeight());
    }

    protected Paint getButtonGradientNormal(JComponent b) {
        return StyleConstants.createButtonGradientNormal(0.0f, b.getHeight());
    }

    protected Paint getPressedPaint(JComponent b) {
        return PureAbstractButtonUI.getPressedGradient(b);
    }

    protected void drawButtonRect(Graphics2D g2d, AbstractButton button) {
        g2d.drawRect(0, 0, button.getWidth() - LafUtils.scalingInt(1), button.getHeight() - LafUtils.scalingInt(1));
    }

    public static Paint getPressedGradient(JComponent c) {
        return new GradientPaint(0.0f, 0.0f, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, c.getHeight(), PureLookAndFeel.getCurrentTheme().getGradientLightColor());
    }

    private void paintFocus(Graphics g, AbstractButton b) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(PureLookAndFeel.getCurrentTheme().getFocusColor());
        g2d.drawRect(0, 0, b.getWidth() - LafUtils.scalingInt(1), b.getHeight() - LafUtils.scalingInt(1));
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().darker());
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }
}

