/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.AbstractToggleButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.text.View;

public abstract class PureAbstractToggleButtonUI
extends AbstractToggleButtonUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = LafUtils.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (this.paintRolloverPressed() && this.adapter.rollover && model.isEnabled()) {
            this.paintRollover((Graphics2D)g, b);
        } else if (model.isArmed() && model.isPressed() || model.isSelected()) {
            this.paintButtonPressed(g, b);
        } else if (this.adapter.rollover && model.isEnabled()) {
            this.paintRollover((Graphics2D)g, b);
        } else {
            this.paintBackground((Graphics2D)g, b, this.getBackground(c));
        }
        if (this.paintBorderDefault() && b.isBorderPainted() && !model.isPressed() && !model.isSelected()) {
            this.paintBorder((Graphics2D)g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        Color textColor = model.isSelected() || model.isPressed() ? this.getSelectedForeground(c) : (this.adapter.rollover ? this.getRolloverForeground(c) : this.getForeground(c));
        if (model.isEnabled()) {
            StringTokenizer tokenizer = new StringTokenizer(text, this.isWrapText() ? "\n" : "");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor);
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                String token = tokenizer.nextToken();
                int x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
        } else {
            int x;
            String token;
            StringTokenizer tokenizer = new StringTokenizer(text, this.isWrapText() ? "\n" : "");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor.brighter());
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
            g.setColor(b.getBackground().darker());
            i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x - LafUtils.scalingInt(1), nextY - LafUtils.scalingInt(1));
                ++i;
                nextY += line_height;
            }
        }
    }

    protected boolean isWrapText() {
        return true;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.paintBackground((Graphics2D)g, b, this.getSelectedBackground(b));
    }

    protected void paintBorder(Graphics2D g2d, AbstractButton button) {
        g2d.setPaint(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
        g2d.drawRect(0, 0, button.getWidth() - LafUtils.scalingInt(1), button.getHeight() - LafUtils.scalingInt(1));
    }

    protected void paintRollover(Graphics2D g, AbstractButton b) {
        this.paintBackground(g, b, this.getRolloverBackground(b));
    }

    private void paintBackground(Graphics2D g2d, AbstractButton button, Paint gradient) {
        if (button.isContentAreaFilled()) {
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected Color getForeground(JComponent c) {
        return c.getForeground();
    }

    protected Color getRolloverForeground(JComponent c) {
        return c.getForeground();
    }

    protected Color getSelectedForeground(JComponent c) {
        return Color.WHITE;
    }

    protected abstract Paint getBackground(JComponent var1);

    protected abstract Paint getSelectedBackground(JComponent var1);

    protected abstract Paint getRolloverBackground(JComponent var1);

    protected abstract boolean paintBorderDefault();

    protected abstract boolean paintRolloverPressed();
}

