/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import com.agilemind.utils.StyleConstants;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.plaf.basic.BasicArrowButton;

public class PureArrowButton
extends BasicArrowButton {
    private final ImageIcon imageIcon;
    private boolean drawLeftLine;

    public PureArrowButton(int direction) {
        this(direction, true);
    }

    public PureArrowButton(int direction, boolean drawLeftLine) {
        super(direction);
        this.drawLeftLine = drawLeftLine;
        this.imageIcon = direction == 7 ? StyleConstants.arrowLeft() : (direction == 3 ? StyleConstants.arrowRight() : (direction == 1 ? StyleConstants.arrowUp() : StyleConstants.arrowDown()));
    }

    @Override
    public void paint(Graphics g) {
        ButtonModel buttonModel = this.getModel();
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        if (buttonModel.isPressed()) {
            g2d.setPaint(StyleConstants.createButtonGradientNormal(0.0f, height));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, height, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, 0.0f, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()));
        }
        g2d.fillRect(0, 0, width, height);
        g2d.setPaint(buttonModel.isPressed() ? PureLookAndFeel.getCurrentTheme().getFocusColor() : PureLookAndFeel.getCurrentTheme().getPrimaryControl());
        int onePixel = LafUtils.scalingInt(1);
        g2d.drawLine(0, 0, width - onePixel, 0);
        g2d.drawLine(0, height - onePixel, width - onePixel, height - onePixel);
        g2d.drawLine(width - onePixel, 0, width - onePixel, height - onePixel);
        if (this.drawLeftLine) {
            g2d.drawLine(0, 0, 0, height - onePixel);
        }
        Image image = this.imageIcon.getImage();
        ImageObserver imageObserver = StyleConstants.arrowLeft().getImageObserver();
        int imageWidth = image.getWidth(imageObserver);
        int imageHeight = image.getHeight(imageObserver);
        if (!this.isEnabled()) {
            image = ((ImageIcon)LafUtils.getColorizedIcon(this.imageIcon, this.getBackground().darker())).getImage();
        }
        g2d.drawImage(image, (width - imageWidth) / 2, (height - imageHeight) / 2, imageObserver);
    }

    @Override
    public Dimension getPreferredSize() {
        return LafUtils.createScaledDimension(super.getPreferredSize());
    }
}

