/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureComboBoxUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public class PureComboBoxButton
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private final PureComboBoxUI comboBoxUI;
    private JComboBox comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private static final ColorUIResource MAIN_COLOR = new ColorUIResource(new Color(245, 245, 245));
    private static final Color GLARE = new Color(254, 254, 254);
    private static final int ONE_PIXEL = LafUtils.scalingInt(1);

    PureComboBoxButton(JComboBox comboBox, Icon comboIcon, boolean iconOnly, CellRendererPane rendererPane, JList listBox, PureComboBoxUI comboBoxUI) {
        super("");
        this.comboBoxUI = comboBoxUI;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.comboBox = comboBox;
        this.comboIcon = comboIcon;
        this.iconOnly = iconOnly;
        this.rendererPane = rendererPane;
        this.listBox = listBox;
        this.setEnabled(comboBox.isEnabled());
        this.setRequestFocusEnabled(comboBox.isEnabled());
        this.setOpaque(false);
        this.setMargin(EMPTY_INSETS);
        this.setUI(new PureComboButtonUI());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        if (this.comboIcon != null) {
            int iconTop;
            int iconLeft;
            int iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                iconLeft = (this.getWidth() - iconWidth) / 2;
                iconTop = (this.getHeight() - iconHeight) / 2;
            } else {
                iconLeft = left + (width - LafUtils.scalingInt(1)) - iconWidth - LafUtils.scalingInt(3);
                iconTop = (this.getHeight() - iconHeight) / 2;
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            int w = this.getWidth() - left - UIManager.getInt("ScrollBar.width") - LafUtils.scalingInt(1);
            c.setFont(UIManager.getFont("ComboBox.font"));
            this.configureColors(c);
            c.setBackground(new Color(0, 0, 0, 0));
            boolean shouldValidate = c instanceof JPanel;
            this.rendererPane.paintComponent(g, c, this, left, top, w, height, shouldValidate);
        }
    }

    private void configureColors(Component c) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("Button.select"));
            }
            c.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        }
    }

    public void setIconOnly(boolean editable) {
        this.iconOnly = editable;
    }

    class PureComboButtonUI
    extends BasicButtonUI {
        private PureComboButtonUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2d = (Graphics2D)g;
            int height = c.getHeight();
            int width = c.getWidth();
            ButtonModel model1 = ((AbstractButton)c).getModel();
            ColorUIResource borderColor = !model1.isPressed() && PureComboBoxButton.this.comboBoxUI.isHasFocus() ? PureLookAndFeel.getCurrentTheme().getFocusColor() : PureLookAndFeel.getCurrentTheme().getPrimaryControl();
            g2d.setPaint(borderColor);
            g2d.fillRect(0, 0, width, height);
            g2d.setPaint(GLARE);
            g2d.fillRect(ONE_PIXEL, ONE_PIXEL, width - ONE_PIXEL * 2, height - ONE_PIXEL * 2);
            if (model1.isRollover()) {
                g2d.setPaint(MAIN_COLOR.brighter());
            } else {
                g2d.setPaint(MAIN_COLOR);
            }
            g2d.fillRect(ONE_PIXEL, ONE_PIXEL * 2, width - ONE_PIXEL * 2, height - ONE_PIXEL * 2 - ONE_PIXEL);
            new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), 76);
            g2d.setColor(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), 76));
            Shape clip = g2d.getClip();
            Rectangle bounds = clip.getBounds();
            bounds.height += ONE_PIXEL * 2;
            g2d.setClip(bounds);
            g2d.fillRect(0, height, width, ONE_PIXEL);
        }
    }
}

