/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureAbstractButtonUI;
import com.agilemind.utils.LafUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class PureComboBoxButtonUI
extends PureAbstractButtonUI {
    private boolean drawLeftBorder = true;
    private JComponent prefSizeCounter;

    public PureComboBoxButtonUI() {
    }

    public PureComboBoxButtonUI(boolean drawLeftBorder, JComponent prefSizeCounter) {
        this.drawLeftBorder = drawLeftBorder;
        this.prefSizeCounter = prefSizeCounter;
    }

    public static ComponentUI createUI(JComponent c) {
        return new PureComboBoxButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFont(c.getFont().deriveFont(0, LafUtils.scalingFloat(11.0f)));
        int bottomBorder = LafUtils.isMacOS() ? 4 : 5;
        c.setBorder(LafUtils.createEmptyBorder(5, 5, bottomBorder, 5));
    }

    @Override
    protected void drawButtonRect(Graphics2D g2d, AbstractButton button) {
        int onePixel = LafUtils.scalingInt(1);
        g2d.drawLine(0, 0, button.getWidth() - onePixel, 0);
        g2d.drawLine(button.getWidth() - onePixel, 0, button.getWidth() - onePixel, button.getHeight() - onePixel);
        g2d.drawLine(button.getWidth() - onePixel, button.getHeight() - onePixel, 0, button.getHeight() - onePixel);
        if (this.drawLeftBorder) {
            g2d.drawLine(0, button.getHeight() - onePixel, 0, 0);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (this.prefSizeCounter != null) {
            Dimension dimension = this.prefSizeCounter.getPreferredSize();
            preferredSize.height = Math.max(dimension.height, preferredSize.height);
        }
        return preferredSize;
    }
}

