/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PureComponentMouseAdapter {
    protected boolean rollover;
    private Component component;
    protected boolean pressed;
    private ComponentMouseAdapter componentMouseAdapter;

    protected PureComponentMouseAdapter(Component component) {
        this.component = component;
        this.componentMouseAdapter = new ComponentMouseAdapter();
    }

    public void installAdapter() {
        this.component.addMouseListener(this.componentMouseAdapter);
    }

    public void uninstallAdapter() {
        this.component.removeMouseListener(this.componentMouseAdapter);
    }

    public boolean isRollover() {
        return this.rollover;
    }

    private class ComponentMouseAdapter
    extends MouseAdapter {
        private ComponentMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PureComponentMouseAdapter.this.rollover = true;
            PureComponentMouseAdapter.this.component.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PureComponentMouseAdapter.this.rollover = false;
            PureComponentMouseAdapter.this.component.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PureComponentMouseAdapter.this.pressed = true;
            PureComponentMouseAdapter.this.component.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PureComponentMouseAdapter.this.pressed = false;
            PureComponentMouseAdapter.this.component.repaint();
        }
    }
}

