/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureAbstractButtonUI;
import com.agilemind.utils.LafUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class PureLinkButtonUI
extends PureAbstractButtonUI {
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color BACKGROUND_ROLLOVER = Color.WHITE;
    public static final Color GREEN_TEXT = new Color(5348380);

    public static ComponentUI createUI(JComponent c) {
        return new PureLinkButtonUI();
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void drawButtonRect(Graphics2D g2d, AbstractButton button) {
    }

    @Override
    protected Paint getButtonGradientHover(JComponent c) {
        return BACKGROUND;
    }

    @Override
    protected Paint getButtonGradientNormal(JComponent c) {
        return BACKGROUND_ROLLOVER;
    }

    @Override
    protected Paint getPressedPaint(JComponent c) {
        return BACKGROUND_ROLLOVER;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            int sz1 = LafUtils.scalingInt(1);
            int sz2 = LafUtils.scalingInt(2);
            Color foreground = model.isRollover() ? this.getRolloverTextColor(c) : b.getForeground();
            g.setColor(foreground);
            int offset = this.pressedOffset(model.isPressed());
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + offset);
            int y = textRect.y + fm.getAscent() + sz1;
            Line2D.Double underlineLine = new Line2D.Double(textRect.x, y + offset, textRect.x + textRect.width + sz1, y + offset);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(sz1, 0, 2, 0.0f, new float[]{sz2, sz2}, 0.0f));
            g2.draw(underlineLine);
        } else {
            g.setColor(b.getBackground().darker());
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected int pressedOffset(boolean pressed) {
        return 0;
    }

    protected Color getRolloverTextColor(JComponent c) {
        return GREEN_TEXT;
    }
}

