/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.AbstractToggleButtonUI;
import com.agilemind.plaf.PureLinkButtonUI;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.text.View;

public class PureLinkToggleButtonUI
extends AbstractToggleButtonUI {
    @Override
    public void update(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets insets = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += insets.left;
        viewRect.y += insets.top;
        viewRect.width -= insets.right + viewRect.x;
        viewRect.height -= insets.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = this.handleText(b, fm, viewRect, iconRect, textRect);
        g.setColor(b.getBackground());
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected String handleText(AbstractButton b, FontMetrics fm, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        return LafUtils.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        Color textColor = model.isSelected() || model.isPressed() || this.adapter.rollover ? PureLinkButtonUI.GREEN_TEXT : c.getForeground();
        this.paintTextLine(g, b, textRect);
        if (model.isEnabled()) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor);
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                String token = tokenizer.nextToken();
                int x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
        } else {
            int x;
            String token;
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor.brighter());
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
            g.setColor(b.getBackground().darker());
            i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                int onePixel = LafUtils.scalingInt(1);
                LafUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x - onePixel, nextY - onePixel);
                ++i;
                nextY += line_height;
            }
        }
    }

    void paintTextLine(Graphics g, AbstractButton c, Rectangle textRect) {
    }
}

