/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.Borders;
import com.agilemind.plaf.LookAndFeelProxy;
import com.agilemind.plaf.PureTableCorner;
import com.agilemind.plaf.scheme.ButtonColorScheme;
import com.agilemind.plaf.scheme.ColorScheme;
import com.agilemind.plaf.scheme.ComboBoxScheme;
import com.agilemind.plaf.scheme.FilterComboBoxScheme;
import com.agilemind.plaf.scheme.ListScheme;
import com.agilemind.plaf.scheme.MenuColorScheme;
import com.agilemind.plaf.scheme.TabbedPaneScheme;
import com.agilemind.plaf.scheme.TextFieldScheme;
import com.agilemind.plaf.scheme.TextPaneColorScheme;
import com.agilemind.plaf.scheme.ToggleButtonColorScheme;
import com.agilemind.utils.LafUtils;
import com.agilemind.utils.MenuItemRenderer;
import com.agilemind.utils.ShadowBorder;
import com.agilemind.utils.ShadowPopupFactory;
import com.agilemind.utils.StyleConstants;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import sun.swing.SwingUtilities2;

public class PureLookAndFeel
extends LookAndFeelProxy {
    private static ColorScheme currentTheme = ColorScheme.DEFAULT;

    public PureLookAndFeel() {
        String targetClassName = LafUtils.isMacOS() ? UIManager.getSystemLookAndFeelClassName() : "javax.swing.plaf.metal.MetalLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    @Override
    public String getDescription() {
        return "Cross-platform Java Pure LookAndFeel";
    }

    @Override
    public String getName() {
        return "PureLookAndFeel";
    }

    @Override
    public String getID() {
        return this.target.getID();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return super.isNativeLookAndFeel();
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return super.isSupportedLookAndFeel();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = this.target.getDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        return table;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String barUI;
        String uiClassNamePrefix = "com.agilemind.plaf.Pure";
        String menuBarUI = LafUtils.isMacOS() ? ((barUI = table.getString("MenuBarUI")) != null ? barUI : "com.apple.laf.AquaMenuBarUI") : "com.agilemind.plaf.PureMenuBarUI";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.agilemind.plaf.PureButtonUI", "CheckBoxMenuItemUI", "com.agilemind.plaf.PureCheckBoxMenuItemUI", "CheckBoxUI", "com.agilemind.plaf.PureCheckBoxUI", "CheckBoxThreeStateUI", "com.agilemind.plaf.PureCheckBoxThreeStateUI", "ComboBoxUI", "com.agilemind.plaf.PureComboBoxUI", "MenuUI", "com.agilemind.plaf.PureMenuUI", "MenuBarUI", menuBarUI, "MenuItemUI", "com.agilemind.plaf.PureMenuItemUI", "OptionPaneUI", "com.agilemind.plaf.PureOptionPaneUI", "PopupMenuSeparatorUI", "com.agilemind.plaf.PurePopupMenuSeparatorUI", "ListUI", "com.agilemind.plaf.PureListUI", "RadioButtonUI", "com.agilemind.plaf.PureRadioButtonUI", "RadioButtonMenuItemUI", "com.agilemind.plaf.PureRadioButtonMenuItemUI", "ScrollBarUI", "com.agilemind.plaf.PureScrollBarUI", "ScrollPaneUI", "com.agilemind.plaf.PureScrollPaneUI", "SliderUI", "com.agilemind.plaf.PureSliderUI", "SplitPaneUI", "com.agilemind.plaf.PureSplitPaneUI", "TabbedPaneUI", "com.agilemind.plaf.PureTabbedPaneUI", "TableHeaderUI", "com.agilemind.plaf.PureTableHeaderUI", "TableUI", "com.agilemind.plaf.PureTableUI", "TextFieldUI", "com.agilemind.plaf.PureTextFieldUI", "ToolTipUI", "com.agilemind.plaf.PureTooltipUI", "ToolBarUI", "com.agilemind.plaf.PureToolBarUI", "SpinnerUI", "com.agilemind.plaf.PureSpinnerUI", "SeparatorUI", "com.agilemind.plaf.PureSeparatorUI", "ToggleButtonUI", "com.agilemind.plaf.PureToggleButtonUI", "TreeUI", "com.agilemind.plaf.PureTreeUI", "ProgressBarUI", "com.agilemind.plaf.PureProgressBarUI", "PasswordFieldUI", "com.agilemind.plaf.PurePasswordFieldUI", "CustomFileChooserUI", "com.agilemind.commons.gui.filechooser.CustomFileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    public static int getTableRowHeight() {
        return LafUtils.scalingInt(30);
    }

    public static int getListRowHeight() {
        return LafUtils.scalingInt(30);
    }

    private static InsetsUIResource createInsets(int top, int left, int bottom, int right) {
        return new InsetsUIResource(LafUtils.scalingInt(top), LafUtils.scalingInt(left), LafUtils.scalingInt(bottom), LafUtils.scalingInt(right));
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        InsetsUIResource emptyInsets = PureLookAndFeel.createInsets(0, 0, 0, 0);
        InsetsUIResource pixelInsets = PureLookAndFeel.createInsets(1, 1, 1, 1);
        BorderUIResource.EmptyBorderUIResource emptyBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        int defaultGap = LafUtils.scalingInt(8);
        ComboBoxScheme comboBoxScheme = currentTheme.getComboBoxScheme();
        ListScheme listScheme = currentTheme.getListScheme();
        TextFieldScheme textFieldScheme = currentTheme.getTextFieldScheme();
        MenuColorScheme menuColorScheme = currentTheme.getMenuColorScheme();
        MenuColorScheme mainMenuColorScheme = currentTheme.getMainMenuColorScheme();
        FilterComboBoxScheme mainComboBoxScheme = currentTheme.getMainComboBoxScheme();
        ButtonColorScheme mainToolbarButtonScheme = currentTheme.getMainToolbarButtonScheme();
        TabbedPaneScheme mainTabbedPaneScheme = currentTheme.getMainTabbedPaneScheme();
        TabbedPaneScheme tabbedPaneScheme = currentTheme.getTabbedPaneScheme();
        ToggleButtonColorScheme mainTabbedPaneToggleButtonColorScheme = currentTheme.getMainTabbedPaneToggleButtonColorScheme();
        ToggleButtonColorScheme mainTabbedPaneInnerToggleButtonColorScheme = currentTheme.getMainTabbedPaneInnerToggleButtonColorScheme();
        ToggleButtonColorScheme toggleButtonColorScheme = currentTheme.getToggleButtonColorScheme();
        TextPaneColorScheme textPaneColorScheme = currentTheme.getTextPaneColorScheme();
        ColorUIResource acceleratorForeground = currentTheme.getAcceleratorForeground();
        ColorUIResource primaryControl = currentTheme.getPrimaryControl();
        ColorUIResource control = currentTheme.getControl();
        ColorUIResource controlHighlight = currentTheme.getAcceleratorSelectedForeground();
        ColorUIResource controlTextColor = currentTheme.getAcceleratorForeground();
        ColorUIResource menuBackground = currentTheme.getControl();
        InsetsUIResource tabbedPaneTabInsets = PureLookAndFeel.createInsets(5, 14, 5, 14);
        Border textFieldBorder = Borders.getTextFieldBorder();
        Border progressBarBorder = Borders.getProgressBarBorder();
        BorderUIResource.LineBorderUIResource scrollPaneBorder = new BorderUIResource.LineBorderUIResource(currentTheme.getPrimaryControl(), LafUtils.scalingInt(1));
        BorderUIResource tableScrollPaneBorder = new BorderUIResource(ShadowBorder.DOWN);
        InsetsUIResource textInsets = PureLookAndFeel.createInsets(1, 5, 1, 5);
        EmptyBorder toggleButtonBorder = LafUtils.createEmptyBorder(4, 6, 4, 6);
        EmptyBorder tableCellBorder = LafUtils.createEmptyBorder(0, 10, 0, 10);
        Object[] defaults = new Object[]{"taskManager.button.foreground", mainTabbedPaneToggleButtonColorScheme.getForeground(), "taskManager.button.rolloverForeground", mainTabbedPaneToggleButtonColorScheme.getRolloverForeground(), "taskManager.button.background", mainTabbedPaneToggleButtonColorScheme.getBackground(), "taskManager.button.rolloverBackground", mainTabbedPaneToggleButtonColorScheme.getRolloverBackground(), "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.borderPaintsFocus", Boolean.TRUE, "Button.textIconGap", defaultGap, "Button.font", StyleConstants.getButtonTextFont(table.getFont("Button.font")), "Button.border", toggleButtonBorder, "ComboBox.background", comboBoxScheme.getBackground(), "ComboBox.selectionBackground", comboBoxScheme.getSelectionBackground(), "ComboBox.foreground", comboBoxScheme.getForeground(), "ComboBox.disabledBackground", comboBoxScheme.getDisabledBackground(), "ComboBox.selectionForeground", comboBoxScheme.getSelectionForeground(), "ComboBox.disabledForeground", comboBoxScheme.getDisabledForeground(), "ComboBox.editorInsets", pixelInsets, "ComboBox.editorBorderInsets", pixelInsets, "ComboBox.arrowIcon", LafUtils.getSVGIcon("comboBoxArrow", "grey3", 8, 8), "ComboBox.font", StyleConstants.getControlTextFont(table, "ComboBox.font"), "CheckBox.background", currentTheme.getBackgroundColor(), "CheckBox.foreground", controlTextColor, "CheckBox.focus", currentTheme.getFocusColor(), "CheckBox.font", StyleConstants.getControlTextFont(table, "CheckBox.font"), "CheckBox.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/checkBox.png"), "CheckBox.disable.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/checkBoxDisable.png"), "CheckBoxThreeState.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/CheckBoxThreeState.png"), "CheckBox.iconColored", PureLookAndFeel.makeIcon(this.getClass(), "icons/checkbox-graph.png"), "CheckBoxMenuItem.acceleratorForeground", menuColorScheme.getItemAcceleratorForeground(), "CheckBoxMenuItem.acceleratorSelectionForeground", menuColorScheme.getItemAcceleratorSelectionForeground(), "CheckBoxMenuItem.background", menuColorScheme.getItemBackground(), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", StyleConstants.getCheckBoxMenuItemIcon(), "CheckBoxMenuItem.font", StyleConstants.getControlTextFont(table, "CheckBoxMenuItem.font"), "CheckBoxMenuItem.foreground", menuColorScheme.getItemForeground(), "CheckBoxMenuItem.selectionForeground", menuColorScheme.getItemSelectionForeground(), "CheckBoxMenuItem.selectionBackground", menuColorScheme.getItemSelectionBackground(), "EditorPane.background", textPaneColorScheme.getBackground(), "EditorPane.selectionBackground", textPaneColorScheme.getSelectionBackground(), "EditorPane.inactiveBackground", textPaneColorScheme.getInactiveBackground(), "EditorPane.foreground", textPaneColorScheme.getForeground(), "EditorPane.selectionForeground", textPaneColorScheme.getSelectionForeground(), "EditorPane.inactiveForeground", textPaneColorScheme.getInactiveForeground(), "FileView.computerIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/computer.png"), "FileView.directoryIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory.png"), "FileView.fileIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/fileIcon.png"), "FileView.floppyDriveIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/floppyDrive.png"), "FileView.hardDriveIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/hardDrive.png"), "FileView.computerIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/computer32.png"), "FileView.directoryIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory32.png"), "FileView.fileIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/fileIcon32.png"), "FileView.floppyDriveIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/floppyDrive32.png"), "FileView.hardDriveIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/hardDrive32.png"), "FileChooser.homeFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/homeFolder.png"), "FileChooser.newFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/newFolder.png"), "FileChooser.upFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/upFolder.png"), "FileChooser.listViewIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/listView.png"), "FileChooser.detailsViewIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/detailsView.png"), "FilterComboBox.background", mainComboBoxScheme.getBackground(), "FilterComboBox.selectionBackground", mainComboBoxScheme.getSelectionBackground(), "FilterComboBox.disabledBackground", mainComboBoxScheme.getDisabledBackground(), "FilterComboBox.arrowBackground", mainComboBoxScheme.getArrowBackground(), "FilterComboBox.listBackground", mainComboBoxScheme.getListBackground(), "FilterComboBox.listBorder", LafUtils.createEmptyBorder(10, 10, 10, 10), "FilterComboBox.foreground", mainComboBoxScheme.getForeground(), "FilterComboBox.selectionForeground", mainComboBoxScheme.getSelectionForeground(), "FilterComboBox.selectedItemForeground", mainComboBoxScheme.getSelectedItemForeground(), "FilterComboBox.textFieldBorder", LafUtils.createEmptyBorder(2, 2, 2, 2), "FilterComboBox.disabledForeground", mainComboBoxScheme.getDisabledForeground(), "FilterComboBox.editorInsets", emptyInsets, "FilterComboBox.editorBorderInsets", emptyInsets, "FilterComboBox.border", emptyBorder, "FilterComboBox.font", StyleConstants.getControlTextFont(table, "ComboBox.font"), "FilterComboBox.scrollBarTrackBackground", mainComboBoxScheme.getScrollBarTrackBackground(), "FilterComboBox.scrollBarThumbBackground", mainComboBoxScheme.getScrollBarThumbBackground(), "FilterComboBox.fixedCellHeight", LafUtils.scalingInt(30), "FormattedTextField.background", textFieldScheme.getBackground(), "FormattedTextField.selectionBackground", textFieldScheme.getSelectionBackground(), "FormattedTextField.disabledBackground", textFieldScheme.getDisabledBackground(), "FormattedTextField.inactiveBackground", textFieldScheme.getInactiveBackground(), "FormattedTextField.border", textFieldBorder, "FormattedTextField.foreground", textFieldScheme.getForeground(), "FormattedTextField.selectionForeground", textFieldScheme.getSelectionForeground(), "FormattedTextField.disabledForeground", textFieldScheme.getDisabledForeground(), "FormattedTextField.inactiveForeground", textFieldScheme.getInactiveForeground(), "FormattedTextField.margin", textInsets, "Label.background", control, "Label.font", StyleConstants.getControlTextFont(table, "Label.font"), "Label.foreground", controlTextColor, "Label.textIconGap", LafUtils.getLabelTextIconGap(), "List.background", listScheme.getBackground(), "List.selectionBackground", listScheme.getSelectionBackground(), "List.foreground", listScheme.getForeground(), "List.selectionForeground", listScheme.getSelectionForeground(), "List.font", StyleConstants.getControlTextFont(table, "List.font"), "List.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(currentTheme.getFocusColor(), LafUtils.scalingInt(1)), "MainTable.border", Borders.MAIN_TABLE_BORDER, "MainTable.borderWithFooter", Borders.MAIN_TABLE_BORDER_WITH_FOOTER, "MainMenu.acceleratorForeground", mainMenuColorScheme.getAcceleratorForeground(), "MainMenu.acceleratorSelectionForeground", mainMenuColorScheme.getAcceleratorSelectionForeground(), "MainMenu.acceleratorFont", StyleConstants.getControlTextFont(table, "Menu.acceleratorFont"), "MainMenu.arrowIcon", StyleConstants.arrowRight(mainMenuColorScheme.getArrowBackground()), "MainMenu.background", mainMenuColorScheme.getBackground(), "MainMenu.borderPainted", Boolean.FALSE, "MainMenu.font", StyleConstants.getControlTextFont(table, "Menu.font"), "MainMenu.foreground", mainMenuColorScheme.getForeground(), "MainMenu.selectionForeground", mainMenuColorScheme.getSelectionForeground(), "MainMenu.selectionBackground", mainMenuColorScheme.getSelectionBackground(), "MainMenu.disabledForeground", mainMenuColorScheme.getDisabledForeground(), "MainMenu.disabledBackground", mainMenuColorScheme.getDisabledBackground(), "MainMenu.textIconGap", defaultGap, "MainMenuItem.acceleratorForeground", mainMenuColorScheme.getItemAcceleratorForeground(), "MainMenuItem.acceleratorSelectionForeground", mainMenuColorScheme.getItemAcceleratorSelectionForeground(), "MainMenuItem.acceleratorFont", StyleConstants.getControlTextFont(table, "MenuItem.acceleratorFont"), "MainMenuItem.background", mainMenuColorScheme.getItemBackground(), "MainMenuItem.borderPainted", Boolean.FALSE, "MainMenuItem.checkIcon", new MenuItemRenderer.MinimumSizedIcon(), "MainMenuItem.font", StyleConstants.getControlTextFont(table, "MenuItem.font"), "MainMenuItem.foreground", mainMenuColorScheme.getItemForeground(), "MainMenuItem.selectionForeground", mainMenuColorScheme.getItemSelectionForeground(), "MainMenuItem.selectionBackground", mainMenuColorScheme.getItemSelectionBackground(), "MainMenuItem.disabledForeground", mainMenuColorScheme.getItemDisabledForeground(), "MainMenuItem.disabledBackground", mainMenuColorScheme.getItemDisabledBackground(), "MainMenuItem.textIconGap", defaultGap, "MainPopupMenuSeparator.background", currentTheme.getMainPopupMenuSeparatorBackground(), "MenuBar.background", currentTheme.getMenuBarBackground(), "MenuBar.border", new BorderUIResource(LafUtils.createEmptyBorder(12, 12, 12, 20)), "MenuBar.font", StyleConstants.getControlTextFont(table, "MenuBar.font"), "Menu.acceleratorForeground", menuColorScheme.getAcceleratorForeground(), "Menu.acceleratorSelectionForeground", menuColorScheme.getAcceleratorSelectionForeground(), "Menu.acceleratorFont", StyleConstants.getControlTextFont(table, "Menu.acceleratorFont"), "Menu.arrowIcon", StyleConstants.arrowRight(menuColorScheme.getArrowBackground()), "Menu.background", menuColorScheme.getBackground(), "Menu.borderPainted", Boolean.FALSE, "Menu.font", StyleConstants.getControlTextFont(table, "Menu.font"), "Menu.foreground", menuColorScheme.getForeground(), "Menu.disabledForeground", menuColorScheme.getDisabledForeground(), "Menu.disabledBackground", menuColorScheme.getDisabledBackground(), "Menu.selectionBackground", menuColorScheme.getSelectionBackground(), "Menu.selectionForeground", menuColorScheme.getSelectionForeground(), "Menu.textIconGap", defaultGap, "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "MenuItem.acceleratorForeground", menuColorScheme.getItemAcceleratorForeground(), "MenuItem.acceleratorSelectionForeground", menuColorScheme.getItemAcceleratorSelectionForeground(), "MenuItem.acceleratorFont", StyleConstants.getControlTextFont(table, "MenuItem.acceleratorFont"), "MenuItem.background", menuColorScheme.getItemBackground(), "MenuItem.borderPainted", Boolean.FALSE, "MenuItem.checkIcon", new MenuItemRenderer.MinimumSizedIcon(), "MenuItem.font", StyleConstants.getControlTextFont(table, "MenuItem.font"), "MenuItem.foreground", menuColorScheme.getItemForeground(), "MenuItem.disabledForeground", menuColorScheme.getItemDisabledForeground(), "MenuItem.disabledBackground", menuColorScheme.getItemDisabledForeground(), "MenuItem.selectionBackground", menuColorScheme.getItemSelectionBackground(), "MenuItem.selectionForeground", menuColorScheme.getItemSelectionForeground(), "MenuItem.textIconGap", defaultGap, "ModulesTabbedPane.background", mainTabbedPaneScheme.getBackground(), "ModulesTabbedPane.selectedBackground", mainTabbedPaneScheme.getSelectedBackground(), "ModulesTabbedPane.font", LafUtils.createScaledFont("Default", 1, 11), "ModulesTabbedPane.foreground", mainTabbedPaneScheme.getForeground(), "ModulesTabbedPane.selectedForeground", mainTabbedPaneScheme.getSelectedForeground(), "ModulesTabbedPane.rolloverForeground", mainTabbedPaneScheme.getRolloverForeground(), "ModulesTabbedPane.tabInsets", PureLookAndFeel.createInsets(30, 5, 30, 5), "ModulesTabbedPane.tabAreaInsets", emptyInsets, "ModulesTabToggleButton.background", mainTabbedPaneToggleButtonColorScheme.getBackground(), "ModulesTabToggleButton.selectedBackground", mainTabbedPaneToggleButtonColorScheme.getSelectedBackground(), "ModulesTabToggleButton.rolloverBackground", mainTabbedPaneToggleButtonColorScheme.getRolloverBackground(), "ModulesTabToggleButton.foreground", mainTabbedPaneToggleButtonColorScheme.getForeground(), "ModulesTabToggleButton.selectedForeground", mainTabbedPaneToggleButtonColorScheme.getSelectedForeground(), "ModulesTabToggleButton.rolloverForeground", mainTabbedPaneToggleButtonColorScheme.getRolloverForeground(), "ModulesInnerTabToggleButton.background", mainTabbedPaneInnerToggleButtonColorScheme.getBackground(), "ModulesInnerTabToggleButton.selectedBackground", mainTabbedPaneInnerToggleButtonColorScheme.getSelectedBackground(), "ModulesInnerTabToggleButton.rolloverBackground", mainTabbedPaneInnerToggleButtonColorScheme.getRolloverBackground(), "ModulesInnerTabToggleButton.foreground", mainTabbedPaneInnerToggleButtonColorScheme.getForeground(), "ModulesInnerTabToggleButton.selectedForeground", mainTabbedPaneInnerToggleButtonColorScheme.getSelectedForeground(), "ModulesInnerTabToggleButton.rolloverForeground", mainTabbedPaneInnerToggleButtonColorScheme.getRolloverForeground(), "OptionPane.background", currentTheme.getBackgroundColor(), "OptionPane.foreground", controlTextColor, "OptionPane.messageForeground", controlTextColor, "OptionPane.errorIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-error.png"), "OptionPane.informationIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-info.png"), "OptionPane.questionIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-question.png"), "OptionPane.warningIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialogWarning.png"), "OptionPane.border", LafUtils.createEmptyBorder(10, 10, 10, 12), "OptionPane.buttonAreaBorder", LafUtils.createEmptyBorder(12, 0, 0, 0), "OperationProgressBar.background", currentTheme.getOperationProgressBarBackground(), "OperationProgressBar.foreground", currentTheme.getOperationProgressBarForeground(), "OperationProgressBar.border", emptyBorder, "Panel.background", currentTheme.getBackgroundColor(), "PasswordField.background", textFieldScheme.getBackground(), "PasswordField.selectionBackground", textFieldScheme.getSelectionBackground(), "PasswordField.disabledBackground", textFieldScheme.getDisabledBackground(), "PasswordField.inactiveBackground", textFieldScheme.getInactiveBackground(), "PasswordField.border", textFieldBorder, "PasswordField.font", StyleConstants.getControlTextFont(table, "TextField.font"), "PasswordField.foreground", textFieldScheme.getForeground(), "PasswordField.selectionForeground", textFieldScheme.getSelectionForeground(), "PasswordField.disabledForeground", textFieldScheme.getDisabledForeground(), "PasswordField.inactiveForeground", textFieldScheme.getInactiveForeground(), "PasswordField.margin", textInsets, "ProgressBar.background", currentTheme.getAcceleratorSelectedForeground(), "ProgressBar.border", progressBarBorder, "ProgressBar.foreground", currentTheme.getFocusColor(), "ProgressBar.font", StyleConstants.getControlTextFont(table, "ProgressBar.font"), "ProgressBar.selectionBackground", acceleratorForeground, "ProgressBar.selectionForeground", currentTheme.getAcceleratorSelectedForeground(), "PopupMenu.background", StyleConstants.POPUP_BACKGROUND, "PopupMenu.border", Borders.getPopupBorder(), "PopupMenu.font", StyleConstants.getControlTextFont(table, "PopupMenu.font"), "PopupMenuSeparator.background", StyleConstants.MENU_SEPARATOR_BACKGROUND, "RadioButton.background", currentTheme.getBackgroundColor(), "RadioButton.foreground", controlTextColor, "RadioButton.shapeBackground", currentTheme.getUnSelectedColor(), "RadioButton.font", StyleConstants.getControlTextFont(table, "RadioButton.font"), "RadioButton.focus", currentTheme.getFocusColor(), "RadioButtonMenuItem.acceleratorForeground", menuColorScheme.getItemAcceleratorForeground(), "RadioButtonMenuItem.acceleratorSelectionForeground", menuColorScheme.getItemSelectionForeground(), "RadioButtonMenuItem.background", menuColorScheme.getItemBackground(), "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", StyleConstants.getRadioButtonMenuItemIcon(), "RadioButtonMenuItem.font", StyleConstants.getControlTextFont(table, "RadioButtonMenuItem.font"), "RadioButtonMenuItem.selectionBackground", menuColorScheme.getItemSelectionBackground(), "RadioButtonMenuItem.selectionForeground", menuColorScheme.getItemSelectionForeground(), "RadioButtonMenuItem.textIconGap", LafUtils.scalingInt(4), "ScrollBar.background", currentTheme.getScrollBarBackground(), "ScrollBar.opaque", Boolean.FALSE, "ScrollBar.width", LafUtils.scalingInt(16), "ScrollBar.minimumThumbSize", LafUtils.createScaledDimension(LafUtils.scalingInt(16), LafUtils.scalingInt(20)), "Slider.font", StyleConstants.getControlTextFont(table, "Slider.font"), "Slider.highlight", controlHighlight, "SplitPane.background", currentTheme.getBackgroundColor(), "SplitPane.dividerFocusColor", primaryControl, "SplitPane.highlight", controlHighlight, "SplitPane.dividerColor", currentTheme.getSplitPaneDividerColor(), "SplitPane.dividerSize", currentTheme.getSplitPaneDividerSize(), "SplitPane.horizontalDividerIcon", StyleConstants.horizontalSplitter(currentTheme.getSplitPaneDividerColor()), "SplitPane.verticalDividerIcon", StyleConstants.verticalSplitter(currentTheme.getSplitPaneDividerColor()), "Spinner.background", control, "Spinner.defaultEditorInsets", pixelInsets, "Spinner.foreground", control, "Spinner.font", StyleConstants.getControlTextFont(table, "Spinner.font"), "ScrollPane.background", currentTheme.getScrollPaneBackground(), "ScrollPane.border", scrollPaneBorder, "ScrollPane.etchedBorder", scrollPaneBorder, "ScrollPane.foreground", controlTextColor, "TabbedPane.background", tabbedPaneScheme.getBackground(), "TabbedPane.focus", controlTextColor, "TabbedPane.font", StyleConstants.getControlTextFont(table, "TabbedPane.font"), "TabbedPane.foreground", tabbedPaneScheme.getForeground(), "TabbedPane.selected", control, "TabbedPane.selectedForeground", tabbedPaneScheme.getSelectedForeground(), "TabbedPane.selectedBackground", tabbedPaneScheme.getSelectedBackground(), "TabbedPane.selectHighlight", controlHighlight, "TabbedPane.tabInsets", tabbedPaneTabInsets, "TabbedPane.tabAreaInsets", emptyInsets, "TabbedPane.contentBorderInsets", emptyBorder, "TabbedPane.textIconGap", defaultGap, "Table.ascendingSortIcon", StyleConstants.arrowUp(), "Table.descendingSortIcon", StyleConstants.arrowDown(), "Table.cellNoFocusBorder", tableCellBorder, "Table.dropLineShortColor", acceleratorForeground, "Table.focusSelectedCellHighlightBorder", tableCellBorder, "Table.focusCellHighlightBorder", tableCellBorder, "Table.focusCellForeground", controlTextColor, "Table.foreground", controlTextColor, "Table.font", StyleConstants.getControlTextFont(table, "Table.font"), "Table.gridColor", currentTheme.getTableGridColor(), "Table.gridSelectedColor", currentTheme.getTableGridSelectedColor(), "Table.rowHeight", PureLookAndFeel.getTableRowHeight(), "Table.lowRowHeight", LafUtils.scalingInt(25), "Table.selectionForeground", currentTheme.getTableSelectionForeground(), "Table.selectionBackground", currentTheme.getTableSelectionBackground(), "Table.hoverForeground", currentTheme.getTableHoverForeground(), "Table.hoverBackground", currentTheme.getTableHoverBackground(), "Table.scrollPaneBorder", tableScrollPaneBorder, "TableHeader.ascIcon", StyleConstants.arrowUp(), "TableHeader.descIcon", StyleConstants.arrowDown(), "TableHeader.height", PureLookAndFeel.getTableRowHeight(), "TableHeader.background", currentTheme.getTableHeaderBackground(), "TableHeader.backgroundSorted", currentTheme.getTableHeaderSortedColor(), "TableHeader.cellBorder", new BorderUIResource(Borders.getTableHeaderBorder()), "TableHeader.font", StyleConstants.getSmallControlTextFont(table.getFont("TableHeader.font")), "TableHeader.foreground", controlTextColor, "TextArea.background", textFieldScheme.getBackground(), "TextArea.foreground", textFieldScheme.getForeground(), "TextArea.selectionBackground", textFieldScheme.getSelectionBackground(), "TextArea.selectionForeground", textFieldScheme.getSelectionForeground(), "TextArea.inactiveForeground", textFieldScheme.getInactiveForeground(), "TextArea.inactiveBackground", textFieldScheme.getInactiveBackground(), "TextArea.font", StyleConstants.getControlTextFont(table, "TextArea.font"), "TextField.background", textFieldScheme.getBackground(), "TextField.selectionBackground", textFieldScheme.getSelectionBackground(), "TextField.disabledBackground", textFieldScheme.getDisabledBackground(), "TextField.inactiveBackground", textFieldScheme.getInactiveBackground(), "TextField.border", textFieldBorder, "TextField.font", StyleConstants.getControlTextFont(table, "TextField.font"), "TextField.foreground", textFieldScheme.getForeground(), "TextField.selectionForeground", textFieldScheme.getSelectionForeground(), "TextField.disabledForeground", textFieldScheme.getDisabledForeground(), "TextField.inactiveForeground", textFieldScheme.getInactiveForeground(), "TextField.margin", textInsets, "TextPane.background", textPaneColorScheme.getBackground(), "TextPane.selectionBackground", textPaneColorScheme.getSelectionBackground(), "TextPane.inactiveBackground", textPaneColorScheme.getInactiveBackground(), "TextPane.foreground", textPaneColorScheme.getForeground(), "TextPane.selectionForeground", textPaneColorScheme.getSelectionForeground(), "TextPane.inactiveForeground", textPaneColorScheme.getInactiveForeground(), "TextPane.font", StyleConstants.getControlTextFont(table, "TextField.font"), "TitledBorder.font", StyleConstants.getControlTextFont(table, "TitledBorder.font"), "TitledBorder.titleColor", controlTextColor, "Tree.collapsedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/treeCollapsed.png"), "Tree.closedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory.png"), "Tree.expandedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/treeExpanded.png"), "Tree.collapsedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/collapsedBranch.png"), "Tree.selectedCollapsedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/collapsedBranchWhite.png"), "Tree.expandedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/expandedBranch.png"), "Tree.selectedExpandedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/expandedBranchWhite.png"), "Tree.foreground", controlTextColor, "Tree.hash", primaryControl, "Tree.line", primaryControl, "Tree.openIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/openFolder.png"), "Tree.rowHeight", PureLookAndFeel.getTableRowHeight(), "Tree.selectionForeground", currentTheme.getTableSelectionForeground(), "Tree.selectionBackground", currentTheme.getTableSelectionBackground(), "Tree.selectionBorderColor", null, "Tree.leftChildIndent", defaultGap, "Tree.rightChildIndent", defaultGap, "Tree.font", StyleConstants.getControlTextFont(table, "Tree.font"), "ToolBar.background", currentTheme.getBackgroundColor(), "ToolBar.dockingForeground", acceleratorForeground, "ToolBar.dockingBackground", menuBackground, "ToolBar.font", StyleConstants.getControlTextFont(table, "ToolBar.font"), "ToolBar.foreground", controlTextColor, "ToolBar.floatingForeground", primaryControl, "ToolBar.floatingBackground", menuBackground, "ToolBar.highlight", controlHighlight, "ToolTip.background", currentTheme.getToolTipBackgournd(), "ToolTip.border", BorderFactory.createEmptyBorder(LafUtils.scalingInt(10), LafUtils.scalingInt(10), LafUtils.scalingInt(10), LafUtils.scalingInt(10)), "ToolTip.font", StyleConstants.getSmallControlTextFont(table.getFont("ToolTip.font")), "ToolTip.foreground", currentTheme.getToolTipForeground(), "ToggleButton.background", toggleButtonColorScheme.getBackground(), "ToggleButton.border", toggleButtonBorder, "ToggleButton.borderPaintsFocus", Boolean.TRUE, "ToggleButton.font", StyleConstants.getButtonTextFont(table.getFont("ToggleButton.font")), "ToggleButton.foreground", toggleButtonColorScheme.getForeground(), "ToolBarButton.background", mainToolbarButtonScheme.getBackground(), "ToolBarButton.foreground", mainToolbarButtonScheme.getForeground(), "ToolBarButton.pressedBackground", mainToolbarButtonScheme.getPressedBackground(), "ToolBarButton.pressedForeground", mainToolbarButtonScheme.getPressedForeground(), "ToolBarButton.rolloverBackground", mainToolbarButtonScheme.getRolloverBackground(), "ToolBarButton.rolloverForeground", mainToolbarButtonScheme.getRolloverForeground(), "ToolBarButton.disabledBackground", mainMenuColorScheme.getDisabledBackground(), "ToolBarButton.disabledForeground", mainMenuColorScheme.getDisabledForeground(), "ToolBarButton.font", StyleConstants.getToolbarButtonTextFont(table.getFont("Button.font")), "ToolBarButton.border", toggleButtonBorder, "ToolBarButton.textIconGap", LafUtils.scalingInt(6), "Viewport.background", currentTheme.getViewportBackground(), "arrowright", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowright.png"), "arrowleft", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowleft.png"), "arrowright_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowrightRollover.png"), "arrowleft_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowleftRollover.png"), "addtab", PureLookAndFeel.makeIcon(this.getClass(), "icons/add.png"), "addtab_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/addRollover.png")};
        table.put("Table.scrollPaneCornerComponent", table1 -> new PureTableCorner());
        table.putDefaults(defaults);
    }

    public static Object makeIcon(Class<?> baseClass, String gifFile) {
        try {
            BufferedImage read = ImageIO.read(PureLookAndFeel.class.getClassLoader().getResourceAsStream(gifFile));
            return new ImageIcon(PureLookAndFeel.resizeImage(read, LafUtils.scalingInt(read.getWidth()), LafUtils.scalingInt(read.getHeight())));
        }
        catch (IOException e) {
            e.printStackTrace();
            return SwingUtilities2.makeIcon(baseClass, baseClass, gifFile);
        }
    }

    private static Image resizeImage(Image image, int width, int height) {
        BufferedImage tmp = new BufferedImage(width, height, 2);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(image, 0, 0, width, height, null);
        g2.dispose();
        return tmp;
    }

    public static ColorScheme getCurrentTheme() {
        return currentTheme;
    }

    public static void setCurrentTheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = colorScheme;
    }
}

