/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class PureMenuBarButtonUI
extends BasicButtonUI {
    private Shape shape;
    private Shape base;
    private Color pressedBackground;
    private Color pressedForeground;
    private Color rolloverForeground;
    private Color rolloverBackground;
    private Color disabledBackground;
    private Color disabledForeground;

    @Override
    protected String getPropertyPrefix() {
        return "ToolBarButton.";
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        this.pressedBackground = UIManager.getColor(this.getPropertyPrefix() + "pressedBackground");
        this.pressedForeground = UIManager.getColor(this.getPropertyPrefix() + "pressedForeground");
        this.rolloverForeground = UIManager.getColor(this.getPropertyPrefix() + "rolloverForeground");
        this.rolloverBackground = UIManager.getColor(this.getPropertyPrefix() + "rolloverBackground");
        this.disabledBackground = UIManager.getColor(this.getPropertyPrefix() + "disabledBackground");
        this.disabledForeground = UIManager.getColor(this.getPropertyPrefix() + "disabledForeground");
        this.initShape(b);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.pressedBackground = null;
        this.pressedForeground = null;
        this.rolloverForeground = null;
        this.rolloverBackground = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getParent() != null ? c.getParent().getBackground() : c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (b.isOpaque()) {
            this.initShape(b);
            PureMenuBarButtonUI.drawButtonShape(g2, this.shape, b.getBackground());
        }
        if (model.isPressed()) {
            this.paintBackground(g, b, this.pressedBackground);
        } else if (model.isRollover()) {
            this.paintBackground(g, b, this.rolloverBackground);
        }
        super.paint(g2, c);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            Color foreground = model.isRollover() ? this.rolloverForeground : (model.isPressed() ? this.pressedForeground : c.getForeground());
            g.setColor(foreground);
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(this.disabledForeground);
            LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private void paintBackground(Graphics g, AbstractButton b, Color background) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            PureMenuBarButtonUI.drawButtonShape(g2d, this.shape, background);
        }
    }

    private void initShape(JComponent c) {
        if (!c.getBounds().equals(this.base)) {
            this.base = c.getBounds();
            this.shape = new Rectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight());
        }
    }

    public void setPressedBackground(Color pressedBackground) {
        this.pressedBackground = pressedBackground;
    }

    public void setPressedForeground(Color pressedForeground) {
        this.pressedForeground = pressedForeground;
    }

    public void setRolloverForeground(Color rolloverForeground) {
        this.rolloverForeground = rolloverForeground;
    }

    public void setRolloverBackground(Color rolloverBackground) {
        this.rolloverBackground = rolloverBackground;
    }

    private static void drawButtonShape(Graphics2D g2, Shape shape, Color background) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(background);
        g2.fill(shape);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

