/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.utils.LafUtils;
import com.agilemind.utils.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class PureMenuItemUI
extends BasicMenuItemUI {
    private final int ITEM_HEIGHT = LafUtils.scalingInt(30);
    private final int MINIMUM_WIDTH = LafUtils.scalingInt(80);
    private final int DEFAULT_GAP = LafUtils.scalingInt(2);
    private MenuItemRenderer renderer;

    public static ComponentUI createUI(JComponent b) {
        return new PureMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.renderer = this.createRenderer(this.menuItem, this.iconBorderEnabled(), this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer gap = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = gap != null ? gap : this.DEFAULT_GAP;
    }

    protected boolean iconBorderEnabled() {
        return false;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon aCheckIcon, Icon anArrowIcon, int textIconGap) {
        Dimension size = this.renderer.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
        int width = Math.max(this.MINIMUM_WIDTH, size.width);
        return new Dimension(width, this.ITEM_HEIGHT);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon aCheckIcon, Icon anArrowIcon, Color background, Color foreground, int textIconGap) {
        this.renderer.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
    }

    protected MenuItemRenderer createRenderer(JMenuItem menuItem, boolean iconBorderEnabled, Font acceleratorFont, Color selectionForeground, Color disabledForeground, Color acceleratorForeground, Color acceleratorSelectionForeground) {
        return new MenuItemRenderer(menuItem, this.iconBorderEnabled(), acceleratorFont, selectionForeground, disabledForeground, acceleratorForeground, acceleratorSelectionForeground);
    }
}

