/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;

public class PureRadioButtonUI
extends MetalRadioButtonUI {
    private boolean rollover;
    private MouseAdapter mouseAdapter;
    private Color shapeColor;
    private static final float ICON_SIZE = LafUtils.scalingFloat(11.0f);

    public static ComponentUI createUI(JComponent c) {
        return new PureRadioButtonUI();
    }

    @Override
    public void installDefaults(final AbstractButton b) {
        super.installDefaults(b);
        this.shapeColor = UIManager.getColor("RadioButton.shapeBackground");
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PureRadioButtonUI.this.rollover = true;
                b.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PureRadioButtonUI.this.rollover = false;
                b.repaint();
            }
        };
        b.addMouseListener(this.mouseAdapter);
        Icon defaultIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                ColorUIResource border;
                Paint fillPaint;
                ButtonModel model = ((AbstractButton)c).getModel();
                if (model.isPressed()) {
                    fillPaint = new GradientPaint(0.0f, (float)y + LafUtils.scalingFloat(1.0f), PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, (float)y + ICON_SIZE - LafUtils.scalingFloat(2.0f), PureLookAndFeel.getCurrentTheme().getGradientLightColor());
                    border = PureLookAndFeel.getCurrentTheme().getFocusColor();
                } else {
                    border = PureLookAndFeel.getCurrentTheme().getPrimaryControl();
                    fillPaint = PureRadioButtonUI.this.rollover ? new GradientPaint(0.0f, (float)y + LafUtils.scalingFloat(1.0f), PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, (float)y + ICON_SIZE - LafUtils.scalingFloat(2.0f), PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()) : Color.WHITE;
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(x, y, ICON_SIZE, ICON_SIZE, ICON_SIZE, ICON_SIZE);
                g2d.setPaint(fillPaint);
                g2d.fill(shape);
                g2d.setPaint(border);
                g2d.draw(shape);
                if (model.isSelected()) {
                    double iconD = LafUtils.scalingDouble(6.0);
                    shape = new RoundRectangle2D.Double((double)x + ((double)ICON_SIZE - iconD) / 2.0, (double)y + ((double)ICON_SIZE - iconD) / 2.0, iconD, iconD, iconD, iconD);
                    g2d.setPaint(PureRadioButtonUI.this.shapeColor);
                    g2d.fill(shape);
                }
            }

            @Override
            public int getIconWidth() {
                return Math.round(ICON_SIZE) + LafUtils.scalingInt(2);
            }

            @Override
            public int getIconHeight() {
                return Math.round(ICON_SIZE);
            }
        };
        b.setIcon(defaultIcon);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.removeMouseListener(this.mouseAdapter);
    }
}

