/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class PureScrollBarUI
extends BasicScrollBarUI {
    private boolean hover;
    private boolean isPressed;

    public static ComponentUI createUI(JComponent c) {
        return new PureScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Adjustable scrollBar = (Adjustable)((Object)c);
        c.setBorder(scrollBar.getOrientation() == 1 ? LafUtils.createEmptyBorder(1, 0, 1, 0) : LafUtils.createEmptyBorder(0, 1, 0, 1));
        LookAndFeel.installProperty(c, "opaque", UIManager.getBoolean("ScrollBar.opaque"));
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(this.getTrackBackground());
        int height = trackBounds.height;
        int width = trackBounds.width;
        int arcWidth = LafUtils.scalingInt(8);
        int arcHeight = LafUtils.scalingInt(8);
        if (this.scrollbar.getOrientation() == 1) {
            int thumbGap = this.getThumbGap();
            g2d.fillRoundRect(thumbGap, 0, width / 2, height, arcWidth, arcHeight);
        } else {
            int thumbGap = this.getThumbGap();
            g2d.fillRoundRect(0, thumbGap, width, height / 2, arcWidth, arcHeight);
        }
        g.translate(-trackBounds.x, -trackBounds.y);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arcWidth = LafUtils.scalingInt(8);
        int arcHeight = LafUtils.scalingInt(8);
        int gap = this.getThumbGap();
        if (this.scrollbar.getOrientation() == 1) {
            g2d.setPaint(this.getFillRectThumbColor());
            g2d.fillRoundRect(thumbBounds.x + gap, thumbBounds.y, thumbBounds.width - gap * 2, thumbBounds.height, arcWidth, arcHeight);
        } else {
            g2d.setPaint(this.getFillRectThumbColor());
            g2d.fillRoundRect(thumbBounds.x, thumbBounds.y + gap, thumbBounds.width, thumbBounds.height - gap * 2, arcWidth, arcHeight);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected int getThumbGap() {
        return LafUtils.scalingInt(4);
    }

    protected Color getTrackBackground() {
        return PureLookAndFeel.getCurrentTheme().getScrollBarTrackBackground();
    }

    protected Paint getFillRectThumbColor() {
        if (this.hover) {
            return PureLookAndFeel.getCurrentTheme().getScrollBarThumbHoverBackground();
        }
        if (this.isPressed) {
            return PureLookAndFeel.getCurrentTheme().getScrollBarThumbPressedBackground();
        }
        return PureLookAndFeel.getCurrentTheme().getScrollBarThumbBackground();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new PureTrackListener();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.incrButton = new JButton();
        this.incrButton.setPreferredSize(new Dimension());
        this.decrButton = new JButton();
        this.decrButton.setPreferredSize(new Dimension());
    }

    protected class PureTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected PureTrackListener() {
            super(PureScrollBarUI.this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            PureScrollBarUI.this.hover = false;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            PureScrollBarUI.this.hover = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            PureScrollBarUI.this.isPressed = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            PureScrollBarUI.this.hover = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            PureScrollBarUI.this.isPressed = false;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }
    }
}

