/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureComponentMouseAdapter;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public abstract class PureShapeButtonUI
extends BasicButtonUI {
    private final int arcwidth;
    private final int archeight;
    private Shape shape;
    private Shape bottomShape;
    private Shape base;
    private PureComponentMouseAdapter adapter;

    protected PureShapeButtonUI() {
        this(LafUtils.scalingInt(6), LafUtils.scalingInt(6));
    }

    protected PureShapeButtonUI(int arcwidth, int archeight) {
        this.arcwidth = arcwidth;
        this.archeight = archeight;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.adapter = new PureComponentMouseAdapter(b);
        this.adapter.installAdapter();
        this.initShape(b);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        this.adapter.uninstallAdapter();
        super.uninstallDefaults(b);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            boolean defaultButton = this.isDefaultButton(b);
            this.drawButtonShape(g2d, this.bottomShape, this.getBorderBackground(defaultButton));
            Color background = this.getBackgroundPressed(defaultButton);
            this.drawButtonShape(g2d, this.shape, background);
            this.drawTopLine(g2d, this.getLineColor(defaultButton), background);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getParent() != null ? c.getParent().getBackground() : c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        if (b.isOpaque()) {
            Color lineColor;
            Color background;
            Color borderBackground;
            this.initShape(b);
            boolean defaultButton = this.isDefaultButton(b);
            if (b.getModel().isEnabled()) {
                borderBackground = this.getBorderBackground(defaultButton);
                background = this.adapter.isRollover() ? this.getRolloverBackground(defaultButton) : this.getBackground(defaultButton);
                lineColor = this.adapter.isRollover() ? this.getRolloverLineColor(defaultButton) : this.getLineColor(defaultButton);
            } else {
                borderBackground = this.getDisabledBorderBackground();
                background = this.getDisableBackground();
                lineColor = this.getDisableLineColor();
            }
            this.drawButtonShape(g2d, this.bottomShape, borderBackground);
            this.drawButtonShape(g2d, this.shape, background);
            this.drawTopLine(g2d, lineColor, background);
        }
        super.paint(g2d, c);
    }

    private void drawButtonShape(Graphics2D g2, Shape shape, Color background) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(background);
        g2.fill(shape);
        g2.setColor(background);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void drawTopLine(Graphics2D g2, Color lineColor, Color background) {
        g2.setColor(lineColor);
        g2.drawLine(LafUtils.scalingInt(3), LafUtils.scalingInt(1), this.shape.getBounds().width - LafUtils.scalingInt(3), LafUtils.scalingInt(1));
        g2.setColor(background);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        boolean defaultButton = this.isDefaultButton(b);
        Color foreground = model.isEnabled() ? this.getForeground(defaultButton) : this.getDisabledForeground();
        g.setColor(foreground);
        LafUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }

    protected abstract Color getBackground(boolean var1);

    protected abstract Color getRolloverBackground(boolean var1);

    protected abstract Color getLineColor(boolean var1);

    protected abstract Color getRolloverLineColor(boolean var1);

    protected abstract Color getDisableLineColor();

    protected abstract Color getDisabledBorderBackground();

    protected abstract Color getDisableBackground();

    protected abstract Color getBorderBackground(boolean var1);

    protected abstract Color getBackgroundPressed(boolean var1);

    protected abstract Color getForeground(boolean var1);

    protected abstract Color getDisabledForeground();

    private void initShape(JComponent c) {
        if (!c.getBounds().equals(this.base)) {
            this.base = c.getBounds();
            this.bottomShape = new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight(), this.arcwidth, this.archeight);
            int onePixel = LafUtils.scalingInt(1);
            int twoPixel = LafUtils.scalingInt(2);
            this.shape = new RoundRectangle2D.Float(onePixel, onePixel, c.getWidth() - twoPixel, c.getHeight() - twoPixel, this.arcwidth - onePixel, this.archeight - onePixel);
        }
    }

    private boolean isDefaultButton(AbstractButton button) {
        return button.getRootPane().getDefaultButton() == button;
    }
}

