/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class PureSliderUI
extends BasicSliderUI {
    private ImageIcon HORIZONTAL_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderHnormal.png"));
    private ImageIcon HORIZONTAL_OVER_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderHover.png"));
    private ImageIcon HORIZONTAL_PRESSED_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderHdown.png"));
    private ImageIcon VERTICAL_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderVnormal.png"));
    private ImageIcon VERTICAL_OVER_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderVover.png"));
    private ImageIcon VERTICAL_PRESSED_ICON = new ImageIcon(PureSliderUI.class.getClassLoader().getResource("icons/sliderVdown.png"));
    private Color trackColor;
    private MouseWheelListener mouseWheelListener;
    private ChangeListener changeListener;
    private MouseListener mouseListener;
    private MouseMotionListener motionListener;
    private boolean rollover = false;

    public PureSliderUI(JSlider c) {
        super(c);
        this.HORIZONTAL_ICON = PureSliderUI.scaleIcon(this.HORIZONTAL_ICON);
        this.HORIZONTAL_OVER_ICON = PureSliderUI.scaleIcon(this.HORIZONTAL_OVER_ICON);
        this.HORIZONTAL_PRESSED_ICON = PureSliderUI.scaleIcon(this.HORIZONTAL_PRESSED_ICON);
        this.VERTICAL_ICON = PureSliderUI.scaleIcon(this.VERTICAL_ICON);
        this.VERTICAL_OVER_ICON = PureSliderUI.scaleIcon(this.VERTICAL_OVER_ICON);
        this.VERTICAL_PRESSED_ICON = PureSliderUI.scaleIcon(this.VERTICAL_PRESSED_ICON);
    }

    private static ImageIcon scaleIcon(ImageIcon icon) {
        Image img = icon.getImage();
        int width = LafUtils.scalingInt(icon.getIconWidth());
        int height = LafUtils.scalingInt(icon.getIconHeight());
        return new ImageIcon(img.getScaledInstance(width, height, 1));
    }

    public static ComponentUI createUI(JComponent c) {
        return new PureSliderUI((JSlider)c);
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        final JSlider slider = (JSlider)c;
        slider.setOpaque(false);
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                slider.setValue(Math.min(Math.max(slider.getMinimum(), slider.getValue() + e.getWheelRotation()), slider.getMaximum()));
            }
        };
        slider.addMouseWheelListener(this.mouseWheelListener);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                slider.repaint();
            }
        };
        slider.addChangeListener(this.changeListener);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                slider.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                slider.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PureSliderUI.this.rollover = true;
                c.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PureSliderUI.this.rollover = false;
                c.repaint();
            }
        };
        this.motionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                slider.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        slider.addMouseListener(this.mouseListener);
        slider.addMouseMotionListener(this.motionListener);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.trackColor = PureLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JSlider slider = (JSlider)c;
        slider.removeMouseWheelListener(this.mouseWheelListener);
        slider.removeChangeListener(this.changeListener);
        slider.removeMouseListener(this.mouseListener);
        slider.removeMouseMotionListener(this.motionListener);
    }

    @Override
    public Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = this.VERTICAL_ICON.getIconWidth();
            size.height = this.VERTICAL_ICON.getIconHeight();
        } else {
            size.width = this.HORIZONTAL_ICON.getIconWidth();
            size.height = this.HORIZONTAL_ICON.getIconHeight();
        }
        return size;
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        int onePixel = LafUtils.scalingInt(1);
        int twoPixels = LafUtils.scalingInt(2);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(LafUtils.scalingFloat(1.0f)));
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - 2;
            int cw = trackBounds.width;
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.setColor(this.trackColor);
            g.drawLine(0, 0, cw, 0);
            g.drawLine(0, twoPixels, cw, twoPixels);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int cx = trackBounds.width / 2 - twoPixels;
            int ch = trackBounds.height;
            g.translate(trackBounds.x + cx, trackBounds.y);
            g.setColor(this.trackColor);
            g.drawLine(twoPixels, 0, twoPixels, ch);
            g.drawLine(onePixel, 0, onePixel, ch);
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        ImageIcon icon;
        int y;
        int x;
        int positionX = this.thumbRect.x + this.thumbRect.width / 2;
        int positionY = this.thumbRect.y + this.thumbRect.height / 2;
        if (this.slider.getOrientation() == 0) {
            x = positionX - this.HORIZONTAL_ICON.getIconWidth() / 2;
            y = positionY - LafUtils.scalingInt(6);
            icon = this.isDragging() ? this.HORIZONTAL_PRESSED_ICON : (this.rollover ? this.HORIZONTAL_OVER_ICON : this.HORIZONTAL_ICON);
        } else {
            x = positionX - LafUtils.scalingInt(8);
            y = positionY - this.VERTICAL_ICON.getIconHeight() / 2;
            icon = this.isDragging() ? this.VERTICAL_PRESSED_ICON : (this.rollover ? this.VERTICAL_OVER_ICON : this.VERTICAL_ICON);
        }
        g.drawImage(icon.getImage(), x, y, null);
    }
}

