/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import sun.swing.ImageIconUIResource;

public class PureSplitPaneUI
extends BasicSplitPaneUI {
    private static final int DIVIDER_SIZE = UIManager.getInt("SplitPane.dividerSize");
    private Boolean dividerBorderVisible = Boolean.FALSE;
    private Boolean hideDivider = Boolean.FALSE;

    public static ComponentUI createUI(JComponent c) {
        return new PureSplitPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSplitPane) {
            JSplitPane pane = (JSplitPane)c;
            pane.setDividerSize(DIVIDER_SIZE);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new Divider(this);
    }

    private static class Divider
    extends BasicSplitPaneDivider {
        private static final Border VERTICAL_DIVIDER_BORDER = BorderFactory.createMatteBorder(LafUtils.scalingInt(1), 0, LafUtils.scalingInt(1), 0, PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
        private static final Border HORIZONTAL_DIVIDER_BORDER = BorderFactory.createMatteBorder(0, LafUtils.scalingInt(1), 0, LafUtils.scalingInt(1), PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
        private final PureSplitPaneUI ui;

        Divider(PureSplitPaneUI ui) {
            super(ui);
            this.ui = ui;
        }

        @Override
        public void paint(Graphics g) {
            int x;
            Graphics2D g2d = (Graphics2D)g;
            if (this.ui.getOrientation() == 0) {
                ImageIconUIResource HORIZONTAL_SPLITTER = (ImageIconUIResource)UIManager.getIcon("SplitPane.verticalDividerIcon");
                x = (this.getWidth() - HORIZONTAL_SPLITTER.getIconWidth()) / 2;
                int y = (this.getHeight() - HORIZONTAL_SPLITTER.getIconHeight()) / 2;
                g.drawImage(HORIZONTAL_SPLITTER.getImage(), x, y, null);
            } else {
                ImageIconUIResource VERTICAL_SPLITTER = (ImageIconUIResource)UIManager.getIcon("SplitPane.horizontalDividerIcon");
                x = (this.getWidth() - VERTICAL_SPLITTER.getIconWidth()) / 2;
                int y = (this.getHeight() - VERTICAL_SPLITTER.getIconHeight()) / 2;
                g.drawImage(VERTICAL_SPLITTER.getImage(), x, y, null);
            }
            if (this.ui.dividerBorderVisible.booleanValue()) {
                Dimension size = this.getSize();
                Border border = this.ui.getOrientation() == 1 ? HORIZONTAL_DIVIDER_BORDER : VERTICAL_DIVIDER_BORDER;
                border.paintBorder(this, g2d, 0, 0, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.ui.hideDivider.booleanValue()) {
                return new Dimension();
            }
            Dimension preferredSize = super.getPreferredSize();
            if (this.ui.getOrientation() == 1) {
                preferredSize.setSize((double)DIVIDER_SIZE, preferredSize.getHeight());
            } else {
                preferredSize.setSize(preferredSize.getWidth(), (double)DIVIDER_SIZE);
            }
            return preferredSize;
        }

        @Override
        public Border getBorder() {
            return BorderFactory.createEmptyBorder();
        }
    }

    private class PropertyChangeHandler
    extends BasicSplitPaneUI.PropertyHandler {
        private PropertyChangeHandler() {
            super(PureSplitPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String changeName = e.getPropertyName();
            if ("dividerBorderVisible".equals(changeName)) {
                PureSplitPaneUI.this.dividerBorderVisible = (Boolean)e.getNewValue();
                this.updateSplitPane();
            } else if ("hideDivider".equals(changeName)) {
                PureSplitPaneUI.this.hideDivider = (Boolean)e.getNewValue();
                this.updateSplitPane();
            } else {
                super.propertyChange(e);
            }
        }

        private void updateSplitPane() {
            PureSplitPaneUI.this.splitPane.revalidate();
            PureSplitPaneUI.this.splitPane.repaint();
        }
    }
}

