/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLinkToggleButtonUI;
import com.agilemind.utils.LafUtils;
import com.agilemind.utils.StyleConstants;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;

public class PureTabToggleButtonUI
extends PureLinkToggleButtonUI {
    private static final int GREEN_LINE_SIZE = LafUtils.scalingInt(4);
    private static int default20_px = LafUtils.scalingInt(20);

    @Override
    public void update(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Integer topInsets = (Integer)c.getClientProperty("topInsets");
        if (topInsets == null) {
            topInsets = default20_px;
        }
        Dimension preferredSize = super.getPreferredSize(c);
        Insets insets = c.getInsets();
        preferredSize.setSize(preferredSize.getWidth() - (double)insets.right - (double)insets.left, (double)(c.getFont().getSize() + default20_px + topInsets));
        return preferredSize;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Integer topInsets = (Integer)c.getClientProperty("topInsets");
        if (topInsets == null) {
            topInsets = default20_px;
        }
        super.paintText(g, c, new Rectangle(textRect.x, topInsets, textRect.width, textRect.height), text);
    }

    @Override
    protected String handleText(AbstractButton b, FontMetrics fm, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        Insets insets = b.getInsets();
        return LafUtils.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), new Rectangle(viewRect.x - insets.left, viewRect.y, viewRect.width + insets.left + insets.right, viewRect.height), iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    void paintTextLine(Graphics g, AbstractButton c, Rectangle textRect) {
        ButtonModel model = c.getModel();
        if (model.isEnabled() && model.isSelected()) {
            Dimension preferredSize = c.getPreferredSize();
            g.setColor(StyleConstants.GREEN_TEXT_ON_WHITE);
            g.fillRect(0, preferredSize.height - GREEN_LINE_SIZE, preferredSize.width, GREEN_LINE_SIZE);
        }
    }
}

