/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.utils.LafUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class PureTooltipUI
extends BasicToolTipUI {
    private static final int PADDING = LafUtils.scalingInt(11);

    public static ComponentUI createUI(JComponent c) {
        return new PureTooltipUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        View v;
        Font font = c.getFont();
        FontMetrics metrics = c.getFontMetrics(font);
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        if ((v = (View)c.getClientProperty("html")) != null) {
            v.paint(g, new Rectangle(PADDING, LafUtils.scalingInt(9), size.width, size.height));
        } else {
            g.setFont(font);
            LafUtils.drawString(c, g, tipText, PADDING, metrics.getAscent() + LafUtils.scalingInt(9));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        Dimension prefSize = new Dimension();
        String text = ((JToolTip)c).getTipText();
        if (text != null && !text.isEmpty()) {
            View v = (View)c.getClientProperty("html");
            int heightAdding = PADDING + LafUtils.scalingInt(8);
            int widthAdding = PADDING * 2;
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0) + widthAdding;
                prefSize.height += (int)v.getPreferredSpan(1) + heightAdding;
            } else {
                prefSize.width += fm.stringWidth(text) + widthAdding;
                prefSize.height += fm.getHeight() + heightAdding;
            }
        }
        return prefSize;
    }
}

