/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.SVGCreator;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class LafUtils {
    public static final String OS_NAME;
    public static final boolean IS_LOW_RESOLUTION;
    private static final String JAVA_VERSION;
    private static final boolean IS_JAVA_5;
    private static final boolean IS_JAVA_6_OR_LATER;
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static final String SWING_UTILITIES2_NAME;
    private static final String ICONS_PATH = "icons/";
    private static final String ICONS_PATH_CSS = "icons/css/";
    private static double screenScaleRating;
    private static Method drawStringMethod;
    private static Method drawStringUnderlineCharAtMethod;
    private static int DEFAULT_FONT_SIZE;
    private static final boolean isOSX;
    private static final boolean isLinux;
    private static Map<Integer, Integer> cache;

    public static void setScreenScaleRating(double screenScaleRating) {
        cache.clear();
        LafUtils.screenScaleRating = screenScaleRating;
        StyleConstants.updateArrows();
        DEFAULT_FONT_SIZE = LafUtils.scalingInt(12);
    }

    public static boolean isMacOS() {
        return isOSX;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void drawRect(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w + LafUtils.scalingInt(1), LafUtils.scalingInt(1));
        g.fillRect(x, y + LafUtils.scalingInt(1), LafUtils.scalingInt(1), h);
        g.fillRect(x + LafUtils.scalingInt(1), y + h, w, LafUtils.scalingInt(1));
        g.fillRect(x + w, y + LafUtils.scalingInt(1), LafUtils.scalingInt(1), h);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        if (drawStringUnderlineCharAtMethod != null) {
            try {
                drawStringUnderlineCharAtMethod.invoke(null, c, g, text, underlinedIndex, x, y);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Map oldRenderingHints = LafUtils.installDesktopHints(g2);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
        if (oldRenderingHints != null) {
            g2.addRenderingHints(oldRenderingHints);
        }
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        if (drawStringMethod != null) {
            try {
                drawStringMethod.invoke(null, c, g, text, x, y);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Map oldRenderingHints = LafUtils.installDesktopHints(g2);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, -1, x, y);
        if (oldRenderingHints != null) {
            g2.addRenderingHints(oldRenderingHints);
        }
    }

    public static Insets createInsets(int top, int left, int bottom, int right) {
        return new Insets(LafUtils.scalingInt(top), LafUtils.scalingInt(left), LafUtils.scalingInt(bottom), LafUtils.scalingInt(right));
    }

    public static Dimension createScaledDimension(Dimension dimension) {
        return LafUtils.createScaledDimension(dimension.getWidth(), dimension.getHeight());
    }

    public static int getDefaultFontSize() {
        return DEFAULT_FONT_SIZE;
    }

    public static double getScalingRate() {
        return screenScaleRating;
    }

    public static int getDefaultGap() {
        return LafUtils.scalingInt(8);
    }

    public static int getLabelTextIconGap() {
        return LafUtils.scalingInt(10);
    }

    public static boolean needScale() {
        return Double.compare(LafUtils.getScalingRate(), 1.0) != 0;
    }

    private static Method getMethodDrawStringUnderlineCharAt() {
        try {
            Class<?> clazz = Class.forName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawStringUnderlineCharAt", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ignore) {
            return null;
        }
    }

    private static Map installDesktopHints(Graphics2D g2) {
        Map desktopHints;
        HashMap<RenderingHints.Key, Object> oldRenderingHints = null;
        if (IS_JAVA_6_OR_LATER && (desktopHints = LafUtils.desktopHints(g2)) != null && !desktopHints.isEmpty()) {
            oldRenderingHints = new HashMap<RenderingHints.Key, Object>(desktopHints.size());
            for (Object o : desktopHints.keySet()) {
                RenderingHints.Key key = (RenderingHints.Key)o;
                oldRenderingHints.put(key, g2.getRenderingHint(key));
            }
            g2.addRenderingHints(desktopHints);
        }
        return oldRenderingHints;
    }

    public static Font createScaledFont(String name, int style, int size) {
        return new Font(name, style, LafUtils.scalingInt(size));
    }

    public static int scalingInt(int size) {
        if (!cache.containsKey(size)) {
            cache.put(size, (int)Math.round((double)size * screenScaleRating));
        }
        return cache.get(size);
    }

    public static double scalingDouble(double size) {
        return size * screenScaleRating;
    }

    public static float scalingFloat(float size) {
        return (float)((double)size * screenScaleRating);
    }

    public static EmptyBorder createEmptyBorder(int top, int right, int bottom, int left) {
        return new EmptyBorder(LafUtils.scalingInt(top), LafUtils.scalingInt(right), LafUtils.scalingInt(bottom), LafUtils.scalingInt(left));
    }

    public static Dimension createScaledDimension(double width, double height) {
        Dimension result = new Dimension();
        result.setSize(LafUtils.scalingDouble(width), LafUtils.scalingDouble(height));
        return result;
    }

    public static Rectangle createRectangle(int x, int y, int width, int height) {
        return new Rectangle(LafUtils.scalingInt(x), LafUtils.scalingInt(y), LafUtils.scalingInt(width), LafUtils.scalingInt(height));
    }

    public static Rectangle createRectangle(Rectangle source) {
        return new Rectangle(LafUtils.scalingInt(source.x), LafUtils.scalingInt(source.y), LafUtils.scalingInt(source.width), LafUtils.scalingInt(source.height));
    }

    private static Map desktopHints(Graphics2D g2) {
        Object aaHint;
        if (LafUtils.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + device.getIDstring());
        if (desktopHints == null) {
            desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
        }
        if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
            desktopHints = null;
        }
        return desktopHints;
    }

    private static Method getMethodDrawString() {
        try {
            Class<?> clazz = Class.forName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawString", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean isLowResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
        }
        catch (HeadlessException e) {
            return true;
        }
    }

    public static Icon getColorizedIcon(Icon icon, Color changeColor) {
        return LafUtils.getColorizedIcon(icon, Color.BLACK, changeColor);
    }

    public static Icon getColorizedIcon(Icon icon, Color searchColor, Color changeColor) {
        if (icon instanceof ImageIcon) {
            int colorRGB = changeColor.getRGB();
            BufferedImage image1 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            BufferedImage image = (BufferedImage)((ImageIcon)icon).getImage();
            for (int m = 0; m < image.getWidth(); ++m) {
                for (int j = 0; j < image.getHeight(); ++j) {
                    int rgb = image.getRGB(m, j);
                    if (rgb != searchColor.getRGB()) continue;
                    image1.setRGB(m, j, colorRGB);
                }
            }
            return new ImageIcon(image1);
        }
        return icon;
    }

    public static String clipString(String string, FontMetrics fm, int availTextWidth) {
        int dotsWidth = fm.stringWidth("...");
        assert (dotsWidth < availTextWidth) : String.format("Required width less then dots(...). Required: %1$d, real:%2$d", availTextWidth, dotsWidth);
        int targetWidth = availTextWidth - dotsWidth;
        int originalSize = fm.stringWidth(string) - dotsWidth;
        if (originalSize <= targetWidth) {
            return string;
        }
        if (dotsWidth >= availTextWidth) {
            return "...";
        }
        StringBuilder sb = new StringBuilder(string.length() + 3);
        for (char c : string.toCharArray()) {
            sb.append(c);
            if (fm.stringWidth(sb.toString()) > targetWidth) break;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("...");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon getSVGIcon(String iconName, String styleName) {
        try (InputStream inputStream1 = PureLookAndFeel.class.getClassLoader().getResourceAsStream(ICONS_PATH + iconName + ".svg");){
            ImageIcon imageIcon = new ImageIcon(SVGCreator.getImage(inputStream1, LafUtils.scalingFloat(16.0f), LafUtils.scalingFloat(16.0f), PureLookAndFeel.class.getClassLoader().getResource(ICONS_PATH_CSS + styleName + ".css").toURI().toString()));
            return imageIcon;
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon getSVGIcon(String iconName, String styleName, int width, int height) {
        try (InputStream inputStream1 = PureLookAndFeel.class.getClassLoader().getResourceAsStream(ICONS_PATH + iconName + ".svg");){
            ImageIcon imageIcon = new ImageIcon(SVGCreator.getImage(inputStream1, LafUtils.scalingFloat(width), LafUtils.scalingFloat(height), PureLookAndFeel.class.getClassLoader().getResource(ICONS_PATH_CSS + styleName + ".css").toURI().toString()));
            return imageIcon;
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int stringWidth(FontMetrics fm, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        if (comp != null) {
            if (comp.isFocusable()) {
                LafUtils.compositeRequestFocus(comp);
                return true;
            }
            if (comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return LafUtils.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        int rsb = 0;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            View v;
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(text, "\n");
                int countTokens = tokenizer.countTokens();
                for (int i = 0; i < countTokens; ++i) {
                    String token = tokenizer.nextToken();
                    textR.width = Math.max(LafUtils.stringWidth(fm, token), textR.width);
                    if (textR.width <= availTextWidth) continue;
                    text = LafUtils.clipString(text, fm, availTextWidth);
                    textR.width = LafUtils.stringWidth(fm, token);
                }
                textR.height = fm.getHeight() * countTokens;
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
        return text;
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        LafUtils.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    static {
        IS_LOW_RESOLUTION = LafUtils.isLowResolution();
        JAVA_VERSION = System.getProperty("java.version");
        IS_JAVA_5 = LafUtils.startsWith(JAVA_VERSION, "1.5");
        IS_JAVA_6_OR_LATER = !IS_JAVA_5;
        SWING_UTILITIES2_NAME = IS_JAVA_6_OR_LATER ? "sun.swing.SwingUtilities2" : "com.sun.java.swing.SwingUtilities2";
        screenScaleRating = 1.0;
        drawStringMethod = null;
        drawStringUnderlineCharAtMethod = null;
        OS_NAME = System.getProperty("os.name");
        drawStringMethod = LafUtils.getMethodDrawString();
        drawStringUnderlineCharAtMethod = LafUtils.getMethodDrawStringUnderlineCharAt();
        DEFAULT_FONT_SIZE = 12;
        isOSX = OS_NAME.toLowerCase().startsWith("mac os");
        isLinux = OS_NAME.toLowerCase().startsWith("linux");
        cache = new HashMap<Integer, Integer>();
    }
}

